// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookChartPoint;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Point Request.
 */
public class WorkbookChartPointRequest extends BaseRequest<WorkbookChartPoint> {
	
    /**
     * The request for the WorkbookChartPoint
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartPointRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartPoint.class);
    }

    /**
     * Gets the WorkbookChartPoint from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPoint> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookChartPoint from the service
     *
     * @return the WorkbookChartPoint from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPoint get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPoint> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookChartPoint delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookChartPoint with a source
     *
     * @param sourceWorkbookChartPoint the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPoint> patchAsync(@Nonnull final WorkbookChartPoint sourceWorkbookChartPoint) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookChartPoint);
    }

    /**
     * Patches this WorkbookChartPoint with a source
     *
     * @param sourceWorkbookChartPoint the source object with updates
     * @return the updated WorkbookChartPoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPoint patch(@Nonnull final WorkbookChartPoint sourceWorkbookChartPoint) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartPoint);
    }

    /**
     * Creates a WorkbookChartPoint with a new object
     *
     * @param newWorkbookChartPoint the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPoint> postAsync(@Nonnull final WorkbookChartPoint newWorkbookChartPoint) {
        return sendAsync(HttpMethod.POST, newWorkbookChartPoint);
    }

    /**
     * Creates a WorkbookChartPoint with a new object
     *
     * @param newWorkbookChartPoint the new object to create
     * @return the created WorkbookChartPoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPoint post(@Nonnull final WorkbookChartPoint newWorkbookChartPoint) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartPoint);
    }

    /**
     * Creates a WorkbookChartPoint with a new object
     *
     * @param newWorkbookChartPoint the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartPoint> putAsync(@Nonnull final WorkbookChartPoint newWorkbookChartPoint) {
        return sendAsync(HttpMethod.PUT, newWorkbookChartPoint);
    }

    /**
     * Creates a WorkbookChartPoint with a new object
     *
     * @param newWorkbookChartPoint the object to create/update
     * @return the created WorkbookChartPoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartPoint put(@Nonnull final WorkbookChartPoint newWorkbookChartPoint) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookChartPoint);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartPointRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartPointRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

