// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IosiPadOSWebClip;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Iosi Pad OSWeb Clip Request.
 */
public class IosiPadOSWebClipRequest extends BaseRequest<IosiPadOSWebClip> {
	
    /**
     * The request for the IosiPadOSWebClip
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IosiPadOSWebClipRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosiPadOSWebClip.class);
    }

    /**
     * Gets the IosiPadOSWebClip from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosiPadOSWebClip> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IosiPadOSWebClip from the service
     *
     * @return the IosiPadOSWebClip from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosiPadOSWebClip get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosiPadOSWebClip> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IosiPadOSWebClip delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IosiPadOSWebClip with a source
     *
     * @param sourceIosiPadOSWebClip the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosiPadOSWebClip> patchAsync(@Nonnull final IosiPadOSWebClip sourceIosiPadOSWebClip) {
        return sendAsync(HttpMethod.PATCH, sourceIosiPadOSWebClip);
    }

    /**
     * Patches this IosiPadOSWebClip with a source
     *
     * @param sourceIosiPadOSWebClip the source object with updates
     * @return the updated IosiPadOSWebClip
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosiPadOSWebClip patch(@Nonnull final IosiPadOSWebClip sourceIosiPadOSWebClip) throws ClientException {
        return send(HttpMethod.PATCH, sourceIosiPadOSWebClip);
    }

    /**
     * Creates a IosiPadOSWebClip with a new object
     *
     * @param newIosiPadOSWebClip the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosiPadOSWebClip> postAsync(@Nonnull final IosiPadOSWebClip newIosiPadOSWebClip) {
        return sendAsync(HttpMethod.POST, newIosiPadOSWebClip);
    }

    /**
     * Creates a IosiPadOSWebClip with a new object
     *
     * @param newIosiPadOSWebClip the new object to create
     * @return the created IosiPadOSWebClip
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosiPadOSWebClip post(@Nonnull final IosiPadOSWebClip newIosiPadOSWebClip) throws ClientException {
        return send(HttpMethod.POST, newIosiPadOSWebClip);
    }

    /**
     * Creates a IosiPadOSWebClip with a new object
     *
     * @param newIosiPadOSWebClip the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosiPadOSWebClip> putAsync(@Nonnull final IosiPadOSWebClip newIosiPadOSWebClip) {
        return sendAsync(HttpMethod.PUT, newIosiPadOSWebClip);
    }

    /**
     * Creates a IosiPadOSWebClip with a new object
     *
     * @param newIosiPadOSWebClip the object to create/update
     * @return the created IosiPadOSWebClip
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosiPadOSWebClip put(@Nonnull final IosiPadOSWebClip newIosiPadOSWebClip) throws ClientException {
        return send(HttpMethod.PUT, newIosiPadOSWebClip);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IosiPadOSWebClipRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IosiPadOSWebClipRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

