// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Login Page Text Visibility Settings.
 */
public class LoginPageTextVisibilitySettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Hide Account Reset Credentials.
     * Option to hide the self-service password reset (SSPR) hyperlinks such as 'Can't access your account?', 'Forgot my password' and 'Reset it now' on the sign-in form.
     */
    @SerializedName(value = "hideAccountResetCredentials", alternate = {"HideAccountResetCredentials"})
    @Expose
	@Nullable
    public Boolean hideAccountResetCredentials;

    /**
     * The Hide Cannot Access Your Account.
     * Option to hide the self-service password reset (SSPR) 'Can't access your account?' hyperlink on the sign-in form.
     */
    @SerializedName(value = "hideCannotAccessYourAccount", alternate = {"HideCannotAccessYourAccount"})
    @Expose
	@Nullable
    public Boolean hideCannotAccessYourAccount;

    /**
     * The Hide Forgot My Password.
     * Option to hide the self-service password reset (SSPR) 'Forgot my password' hyperlink on the sign-in form.
     */
    @SerializedName(value = "hideForgotMyPassword", alternate = {"HideForgotMyPassword"})
    @Expose
	@Nullable
    public Boolean hideForgotMyPassword;

    /**
     * The Hide Privacy And Cookies.
     * Option to hide the 'Privacy &amp; Cookies' hyperlink in the footer.
     */
    @SerializedName(value = "hidePrivacyAndCookies", alternate = {"HidePrivacyAndCookies"})
    @Expose
	@Nullable
    public Boolean hidePrivacyAndCookies;

    /**
     * The Hide Reset It Now.
     * Option to hide the self-service password reset (SSPR) 'reset it now' hyperlink on the sign-in form.
     */
    @SerializedName(value = "hideResetItNow", alternate = {"HideResetItNow"})
    @Expose
	@Nullable
    public Boolean hideResetItNow;

    /**
     * The Hide Terms Of Use.
     * Option to hide the 'Terms of Use' hyperlink in the footer.
     */
    @SerializedName(value = "hideTermsOfUse", alternate = {"HideTermsOfUse"})
    @Expose
	@Nullable
    public Boolean hideTermsOfUse;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
