// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AllowInvitesFrom;
import com.microsoft.graph.models.DefaultUserRolePermissions;
import com.microsoft.graph.models.PolicyBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authorization Policy.
 */
public class AuthorizationPolicy extends PolicyBase implements IJsonBackedObject {


    /**
     * The Allowed To Sign Up Email Based Subscriptions.
     * Indicates whether users can sign up for email based subscriptions.
     */
    @SerializedName(value = "allowedToSignUpEmailBasedSubscriptions", alternate = {"AllowedToSignUpEmailBasedSubscriptions"})
    @Expose
	@Nullable
    public Boolean allowedToSignUpEmailBasedSubscriptions;

    /**
     * The Allowed To Use SSPR.
     * Indicates whether users can use the Self-Serve Password Reset feature on the tenant.
     */
    @SerializedName(value = "allowedToUseSSPR", alternate = {"AllowedToUseSSPR"})
    @Expose
	@Nullable
    public Boolean allowedToUseSSPR;

    /**
     * The Allow Email Verified Users To Join Organization.
     * Indicates whether a user can join the tenant by email validation.
     */
    @SerializedName(value = "allowEmailVerifiedUsersToJoinOrganization", alternate = {"AllowEmailVerifiedUsersToJoinOrganization"})
    @Expose
	@Nullable
    public Boolean allowEmailVerifiedUsersToJoinOrganization;

    /**
     * The Allow Invites From.
     * Indicates who can invite external users to the organization. Possible values are: none, adminsAndGuestInviters, adminsGuestInvitersAndAllMembers, everyone.  everyone is the default setting for all cloud environments except US Government. For more information, see allowInvitesFrom values.
     */
    @SerializedName(value = "allowInvitesFrom", alternate = {"AllowInvitesFrom"})
    @Expose
	@Nullable
    public AllowInvitesFrom allowInvitesFrom;

    /**
     * The Allow User Consent For Risky Apps.
     * Indicates whether user consent for risky apps is allowed. We recommend keeping allowUserConsentForRiskyApps as false. Default value is false.
     */
    @SerializedName(value = "allowUserConsentForRiskyApps", alternate = {"AllowUserConsentForRiskyApps"})
    @Expose
	@Nullable
    public Boolean allowUserConsentForRiskyApps;

    /**
     * The Block Msol Power Shell.
     * To disable the use of MSOL PowerShell, set this property to true. This also disables user-based access to the legacy service endpoint used by MSOL PowerShell. This doesn't affect Microsoft Entra Connect or Microsoft Graph.
     */
    @SerializedName(value = "blockMsolPowerShell", alternate = {"BlockMsolPowerShell"})
    @Expose
	@Nullable
    public Boolean blockMsolPowerShell;

    /**
     * The Default User Role Permissions.
     * Specifies certain customizable permissions for default user role.
     */
    @SerializedName(value = "defaultUserRolePermissions", alternate = {"DefaultUserRolePermissions"})
    @Expose
	@Nullable
    public DefaultUserRolePermissions defaultUserRolePermissions;

    /**
     * The Guest User Role Id.
     * Represents role templateId for the role that should be granted to guest user. Currently following roles are supported:  User (a0b1b346-4d3e-4e8b-98f8-753987be4970), Guest User (10dae51f-b6af-4016-8d66-8c2a99b929b3), and Restricted Guest User (2af84b1e-32c8-42b7-82bc-daa82404023b).
     */
    @SerializedName(value = "guestUserRoleId", alternate = {"GuestUserRoleId"})
    @Expose
	@Nullable
    public java.util.UUID guestUserRoleId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
