// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.identitygovernance.models.LifecycleWorkflowProcessingStatus;
import com.microsoft.graph.identitygovernance.models.WorkflowExecutionType;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage;
import com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Run.
 */
public class Run extends Entity implements IJsonBackedObject {


    /**
     * The Completed Date Time.
     * The date time that the run completed. Value is null if the workflow hasn't completed.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "completedDateTime", alternate = {"CompletedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime completedDateTime;

    /**
     * The Failed Tasks Count.
     * The number of tasks that failed in the run execution.
     */
    @SerializedName(value = "failedTasksCount", alternate = {"FailedTasksCount"})
    @Expose
	@Nullable
    public Integer failedTasksCount;

    /**
     * The Failed Users Count.
     * The number of users that failed in the run execution.
     */
    @SerializedName(value = "failedUsersCount", alternate = {"FailedUsersCount"})
    @Expose
	@Nullable
    public Integer failedUsersCount;

    /**
     * The Last Updated Date Time.
     * The datetime that the run was last updated.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "lastUpdatedDateTime", alternate = {"LastUpdatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastUpdatedDateTime;

    /**
     * The Processing Status.
     * The run execution status. The possible values are: queued, inProgress, completed, completedWithErrors, canceled, failed, unknownFutureValue.Supports $filter(eq, ne) and $orderby.
     */
    @SerializedName(value = "processingStatus", alternate = {"ProcessingStatus"})
    @Expose
	@Nullable
    public LifecycleWorkflowProcessingStatus processingStatus;

    /**
     * The Scheduled Date Time.
     * The date time that the run is scheduled to be executed for a workflow.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "scheduledDateTime", alternate = {"ScheduledDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime scheduledDateTime;

    /**
     * The Started Date Time.
     * The date time that the run execution started.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "startedDateTime", alternate = {"StartedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startedDateTime;

    /**
     * The Successful Users Count.
     * The number of successfully completed users in the run.
     */
    @SerializedName(value = "successfulUsersCount", alternate = {"SuccessfulUsersCount"})
    @Expose
	@Nullable
    public Integer successfulUsersCount;

    /**
     * The Total Tasks Count.
     * 
     */
    @SerializedName(value = "totalTasksCount", alternate = {"TotalTasksCount"})
    @Expose
	@Nullable
    public Integer totalTasksCount;

    /**
     * The Total Unprocessed Tasks Count.
     * The total number of unprocessed tasks in the run execution.
     */
    @SerializedName(value = "totalUnprocessedTasksCount", alternate = {"TotalUnprocessedTasksCount"})
    @Expose
	@Nullable
    public Integer totalUnprocessedTasksCount;

    /**
     * The Total Users Count.
     * The total number of users in the workflow execution.
     */
    @SerializedName(value = "totalUsersCount", alternate = {"TotalUsersCount"})
    @Expose
	@Nullable
    public Integer totalUsersCount;

    /**
     * The Workflow Execution Type.
     * The execution type of the workflows associated with the run. The possible values are: scheduled, onDemand, unknownFutureValue.Supports $filter(eq, ne) and $orderby.
     */
    @SerializedName(value = "workflowExecutionType", alternate = {"WorkflowExecutionType"})
    @Expose
	@Nullable
    public WorkflowExecutionType workflowExecutionType;

    /**
     * The Task Processing Results.
     * The related taskProcessingResults.
     */
    @SerializedName(value = "taskProcessingResults", alternate = {"TaskProcessingResults"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage taskProcessingResults;

    /**
     * The User Processing Results.
     * The associated individual user execution.
     */
    @SerializedName(value = "userProcessingResults", alternate = {"UserProcessingResults"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionPage userProcessingResults;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("taskProcessingResults")) {
            taskProcessingResults = serializer.deserializeObject(json.get("taskProcessingResults"), com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage.class);
        }

        if (json.has("userProcessingResults")) {
            userProcessingResults = serializer.deserializeObject(json.get("userProcessingResults"), com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionPage.class);
        }
    }
}
