/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostComponent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostComponentRequest
extends BaseRequest<HostComponent> {
    public HostComponentRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostComponent.class);
    }

    @Nonnull
    public CompletableFuture<HostComponent> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public HostComponent get() throws ClientException {
        return (HostComponent)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<HostComponent> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public HostComponent delete() throws ClientException {
        return (HostComponent)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<HostComponent> patchAsync(@Nonnull HostComponent sourceHostComponent) {
        return this.sendAsync(HttpMethod.PATCH, sourceHostComponent);
    }

    @Nullable
    public HostComponent patch(@Nonnull HostComponent sourceHostComponent) throws ClientException {
        return (HostComponent)this.send(HttpMethod.PATCH, sourceHostComponent);
    }

    @Nonnull
    public CompletableFuture<HostComponent> postAsync(@Nonnull HostComponent newHostComponent) {
        return this.sendAsync(HttpMethod.POST, newHostComponent);
    }

    @Nullable
    public HostComponent post(@Nonnull HostComponent newHostComponent) throws ClientException {
        return (HostComponent)this.send(HttpMethod.POST, newHostComponent);
    }

    @Nonnull
    public CompletableFuture<HostComponent> putAsync(@Nonnull HostComponent newHostComponent) {
        return this.sendAsync(HttpMethod.PUT, newHostComponent);
    }

    @Nullable
    public HostComponent put(@Nonnull HostComponent newHostComponent) throws ClientException {
        return (HostComponent)this.send(HttpMethod.PUT, newHostComponent);
    }

    @Nonnull
    public HostComponentRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostComponentRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

