/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.identitygovernance.models.Workflow;
import com.microsoft.graph.identitygovernance.models.WorkflowActivateParameterSet;
import com.microsoft.graph.identitygovernance.models.WorkflowCreateNewVersionParameterSet;
import com.microsoft.graph.identitygovernance.requests.RunCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.RunRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskReportCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskReportRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.UserProcessingResultRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.UserProcessingResultWithReferenceRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowActivateRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowCreateNewVersionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowRequest;
import com.microsoft.graph.identitygovernance.requests.WorkflowRestoreRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowVersionCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowVersionRequestBuilder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.UserWithReferenceRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowRequestBuilder
extends BaseRequestBuilder<Workflow> {
    public WorkflowRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public WorkflowRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public WorkflowRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new WorkflowRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public UserWithReferenceRequestBuilder createdBy() {
        return new UserWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("createdBy"), this.getClient(), null);
    }

    @Nonnull
    public UserWithReferenceRequestBuilder lastModifiedBy() {
        return new UserWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("lastModifiedBy"), this.getClient(), null);
    }

    @Nonnull
    public TaskCollectionRequestBuilder tasks() {
        return new TaskCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("tasks"), this.getClient(), null);
    }

    @Nonnull
    public TaskRequestBuilder tasks(@Nonnull String id) {
        return new TaskRequestBuilder(this.getRequestUrlWithAdditionalSegment("tasks") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public UserProcessingResultCollectionWithReferencesRequestBuilder executionScope() {
        return new UserProcessingResultCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("executionScope"), this.getClient(), null);
    }

    @Nonnull
    public UserProcessingResultWithReferenceRequestBuilder executionScope(@Nonnull String id) {
        return new UserProcessingResultWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("executionScope") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public RunCollectionRequestBuilder runs() {
        return new RunCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("runs"), this.getClient(), null);
    }

    @Nonnull
    public RunRequestBuilder runs(@Nonnull String id) {
        return new RunRequestBuilder(this.getRequestUrlWithAdditionalSegment("runs") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public TaskReportCollectionRequestBuilder taskReports() {
        return new TaskReportCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("taskReports"), this.getClient(), null);
    }

    @Nonnull
    public TaskReportRequestBuilder taskReports(@Nonnull String id) {
        return new TaskReportRequestBuilder(this.getRequestUrlWithAdditionalSegment("taskReports") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public UserProcessingResultCollectionRequestBuilder userProcessingResults() {
        return new UserProcessingResultCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("userProcessingResults"), this.getClient(), null);
    }

    @Nonnull
    public UserProcessingResultRequestBuilder userProcessingResults(@Nonnull String id) {
        return new UserProcessingResultRequestBuilder(this.getRequestUrlWithAdditionalSegment("userProcessingResults") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public WorkflowVersionCollectionRequestBuilder versions() {
        return new WorkflowVersionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("versions"), this.getClient(), null);
    }

    @Nonnull
    public WorkflowVersionRequestBuilder versions(@Nonnull String id) {
        return new WorkflowVersionRequestBuilder(this.getRequestUrlWithAdditionalSegment("versions") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public WorkflowActivateRequestBuilder activate(@Nonnull WorkflowActivateParameterSet parameters) {
        return new WorkflowActivateRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.identityGovernance.activate"), this.getClient(), null, parameters);
    }

    @Nonnull
    public WorkflowCreateNewVersionRequestBuilder createNewVersion(@Nonnull WorkflowCreateNewVersionParameterSet parameters) {
        return new WorkflowCreateNewVersionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.identityGovernance.createNewVersion"), this.getClient(), null, parameters);
    }

    @Nonnull
    public WorkflowRestoreRequestBuilder restore() {
        return new WorkflowRestoreRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.identityGovernance.restore"), this.getClient(), null);
    }
}

