// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryApplyTagsRequest;
import com.microsoft.graph.security.models.EdiscoveryReviewSetQuery;
import com.microsoft.graph.security.models.EdiscoveryReviewTag;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.security.models.EdiscoveryReviewSetQueryApplyTagsParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Set Query Apply Tags Request Builder.
 */
public class EdiscoveryReviewSetQueryApplyTagsRequestBuilder extends BaseActionRequestBuilder<EdiscoveryReviewSetQuery> {

    /**
     * The request builder for this EdiscoveryReviewSetQueryApplyTags
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryReviewSetQueryApplyTagsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private EdiscoveryReviewSetQueryApplyTagsParameterSet body;
    /**
     * The request builder for this EdiscoveryReviewSetQueryApplyTags
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public EdiscoveryReviewSetQueryApplyTagsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final EdiscoveryReviewSetQueryApplyTagsParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the EdiscoveryReviewSetQueryApplyTagsRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryReviewSetQueryApplyTagsRequest instance
     */
    @Nonnull
    public EdiscoveryReviewSetQueryApplyTagsRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoveryReviewSetQueryApplyTagsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryReviewSetQueryApplyTagsRequest instance
     */
    @Nonnull
    public EdiscoveryReviewSetQueryApplyTagsRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoveryReviewSetQueryApplyTagsRequest request = new EdiscoveryReviewSetQueryApplyTagsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
