// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Fido2AuthenticationMethodConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Fido2Authentication Method Configuration Request.
 */
public class Fido2AuthenticationMethodConfigurationRequest extends BaseRequest<Fido2AuthenticationMethodConfiguration> {
	
    /**
     * The request for the Fido2AuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Fido2AuthenticationMethodConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Fido2AuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the Fido2AuthenticationMethodConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethodConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Fido2AuthenticationMethodConfiguration from the service
     *
     * @return the Fido2AuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethodConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Fido2AuthenticationMethodConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Fido2AuthenticationMethodConfiguration with a source
     *
     * @param sourceFido2AuthenticationMethodConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethodConfiguration> patchAsync(@Nonnull final Fido2AuthenticationMethodConfiguration sourceFido2AuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceFido2AuthenticationMethodConfiguration);
    }

    /**
     * Patches this Fido2AuthenticationMethodConfiguration with a source
     *
     * @param sourceFido2AuthenticationMethodConfiguration the source object with updates
     * @return the updated Fido2AuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethodConfiguration patch(@Nonnull final Fido2AuthenticationMethodConfiguration sourceFido2AuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceFido2AuthenticationMethodConfiguration);
    }

    /**
     * Creates a Fido2AuthenticationMethodConfiguration with a new object
     *
     * @param newFido2AuthenticationMethodConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethodConfiguration> postAsync(@Nonnull final Fido2AuthenticationMethodConfiguration newFido2AuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.POST, newFido2AuthenticationMethodConfiguration);
    }

    /**
     * Creates a Fido2AuthenticationMethodConfiguration with a new object
     *
     * @param newFido2AuthenticationMethodConfiguration the new object to create
     * @return the created Fido2AuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethodConfiguration post(@Nonnull final Fido2AuthenticationMethodConfiguration newFido2AuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newFido2AuthenticationMethodConfiguration);
    }

    /**
     * Creates a Fido2AuthenticationMethodConfiguration with a new object
     *
     * @param newFido2AuthenticationMethodConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethodConfiguration> putAsync(@Nonnull final Fido2AuthenticationMethodConfiguration newFido2AuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PUT, newFido2AuthenticationMethodConfiguration);
    }

    /**
     * Creates a Fido2AuthenticationMethodConfiguration with a new object
     *
     * @param newFido2AuthenticationMethodConfiguration the object to create/update
     * @return the created Fido2AuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethodConfiguration put(@Nonnull final Fido2AuthenticationMethodConfiguration newFido2AuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newFido2AuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Fido2AuthenticationMethodConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Fido2AuthenticationMethodConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

