// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ChangeTrackedEntity;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Change Tracked Entity Request.
 */
public class ChangeTrackedEntityRequest extends BaseRequest<ChangeTrackedEntity> {
	
    /**
     * The request for the ChangeTrackedEntity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ChangeTrackedEntityRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends ChangeTrackedEntity> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ChangeTrackedEntity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChangeTrackedEntityRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChangeTrackedEntity.class);
    }

    /**
     * Gets the ChangeTrackedEntity from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChangeTrackedEntity> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ChangeTrackedEntity from the service
     *
     * @return the ChangeTrackedEntity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChangeTrackedEntity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChangeTrackedEntity> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ChangeTrackedEntity delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ChangeTrackedEntity with a source
     *
     * @param sourceChangeTrackedEntity the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChangeTrackedEntity> patchAsync(@Nonnull final ChangeTrackedEntity sourceChangeTrackedEntity) {
        return sendAsync(HttpMethod.PATCH, sourceChangeTrackedEntity);
    }

    /**
     * Patches this ChangeTrackedEntity with a source
     *
     * @param sourceChangeTrackedEntity the source object with updates
     * @return the updated ChangeTrackedEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChangeTrackedEntity patch(@Nonnull final ChangeTrackedEntity sourceChangeTrackedEntity) throws ClientException {
        return send(HttpMethod.PATCH, sourceChangeTrackedEntity);
    }

    /**
     * Creates a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChangeTrackedEntity> postAsync(@Nonnull final ChangeTrackedEntity newChangeTrackedEntity) {
        return sendAsync(HttpMethod.POST, newChangeTrackedEntity);
    }

    /**
     * Creates a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the new object to create
     * @return the created ChangeTrackedEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChangeTrackedEntity post(@Nonnull final ChangeTrackedEntity newChangeTrackedEntity) throws ClientException {
        return send(HttpMethod.POST, newChangeTrackedEntity);
    }

    /**
     * Creates a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChangeTrackedEntity> putAsync(@Nonnull final ChangeTrackedEntity newChangeTrackedEntity) {
        return sendAsync(HttpMethod.PUT, newChangeTrackedEntity);
    }

    /**
     * Creates a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the object to create/update
     * @return the created ChangeTrackedEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChangeTrackedEntity put(@Nonnull final ChangeTrackedEntity newChangeTrackedEntity) throws ClientException {
        return send(HttpMethod.PUT, newChangeTrackedEntity);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ChangeTrackedEntityRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ChangeTrackedEntityRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

