// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.WindowsMalwareCategoryCount;
import com.microsoft.graph.models.WindowsMalwareExecutionStateCount;
import com.microsoft.graph.models.WindowsMalwareNameCount;
import com.microsoft.graph.models.WindowsMalwareSeverityCount;
import com.microsoft.graph.models.WindowsMalwareStateCount;
import com.microsoft.graph.models.OsVersionCount;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Malware Overview.
 */
public class WindowsMalwareOverview implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Malware Category Summary.
     * List of device counts per malware category
     */
    @SerializedName(value = "malwareCategorySummary", alternate = {"MalwareCategorySummary"})
    @Expose
	@Nullable
    public java.util.List<WindowsMalwareCategoryCount> malwareCategorySummary;

    /**
     * The Malware Detected Device Count.
     * Count of devices with malware detected in the last 30 days
     */
    @SerializedName(value = "malwareDetectedDeviceCount", alternate = {"MalwareDetectedDeviceCount"})
    @Expose
	@Nullable
    public Integer malwareDetectedDeviceCount;

    /**
     * The Malware Execution State Summary.
     * List of device counts per malware execution state
     */
    @SerializedName(value = "malwareExecutionStateSummary", alternate = {"MalwareExecutionStateSummary"})
    @Expose
	@Nullable
    public java.util.List<WindowsMalwareExecutionStateCount> malwareExecutionStateSummary;

    /**
     * The Malware Name Summary.
     * List of device counts per malware
     */
    @SerializedName(value = "malwareNameSummary", alternate = {"MalwareNameSummary"})
    @Expose
	@Nullable
    public java.util.List<WindowsMalwareNameCount> malwareNameSummary;

    /**
     * The Malware Severity Summary.
     * List of active malware counts per malware severity
     */
    @SerializedName(value = "malwareSeveritySummary", alternate = {"MalwareSeveritySummary"})
    @Expose
	@Nullable
    public java.util.List<WindowsMalwareSeverityCount> malwareSeveritySummary;

    /**
     * The Malware State Summary.
     * List of device counts per malware state
     */
    @SerializedName(value = "malwareStateSummary", alternate = {"MalwareStateSummary"})
    @Expose
	@Nullable
    public java.util.List<WindowsMalwareStateCount> malwareStateSummary;

    /**
     * The Os Versions Summary.
     * List of device counts with malware per windows OS version
     */
    @SerializedName(value = "osVersionsSummary", alternate = {"OsVersionsSummary"})
    @Expose
	@Nullable
    public java.util.List<OsVersionCount> osVersionsSummary;

    /**
     * The Total Distinct Malware Count.
     * Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
     */
    @SerializedName(value = "totalDistinctMalwareCount", alternate = {"TotalDistinctMalwareCount"})
    @Expose
	@Nullable
    public Integer totalDistinctMalwareCount;

    /**
     * The Total Malware Count.
     * Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
     */
    @SerializedName(value = "totalMalwareCount", alternate = {"TotalMalwareCount"})
    @Expose
	@Nullable
    public Integer totalMalwareCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
