/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.IpAddress;
import com.microsoft.graph.security.requests.HostComponentCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostComponentWithReferenceRequestBuilder;
import com.microsoft.graph.security.requests.HostCookieCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostCookieWithReferenceRequestBuilder;
import com.microsoft.graph.security.requests.HostReputationRequestBuilder;
import com.microsoft.graph.security.requests.HostTrackerCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostTrackerWithReferenceRequestBuilder;
import com.microsoft.graph.security.requests.IpAddressRequest;
import com.microsoft.graph.security.requests.PassiveDnsRecordCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.PassiveDnsRecordWithReferenceRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IpAddressRequestBuilder
extends BaseRequestBuilder<IpAddress> {
    public IpAddressRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public IpAddressRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public IpAddressRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new IpAddressRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public HostComponentCollectionWithReferencesRequestBuilder components() {
        return new HostComponentCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("components"), this.getClient(), null);
    }

    @Nonnull
    public HostComponentWithReferenceRequestBuilder components(@Nonnull String id) {
        return new HostComponentWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("components") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public HostCookieCollectionWithReferencesRequestBuilder cookies() {
        return new HostCookieCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("cookies"), this.getClient(), null);
    }

    @Nonnull
    public HostCookieWithReferenceRequestBuilder cookies(@Nonnull String id) {
        return new HostCookieWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("cookies") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public PassiveDnsRecordCollectionWithReferencesRequestBuilder passiveDns() {
        return new PassiveDnsRecordCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("passiveDns"), this.getClient(), null);
    }

    @Nonnull
    public PassiveDnsRecordWithReferenceRequestBuilder passiveDns(@Nonnull String id) {
        return new PassiveDnsRecordWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("passiveDns") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public PassiveDnsRecordCollectionWithReferencesRequestBuilder passiveDnsReverse() {
        return new PassiveDnsRecordCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("passiveDnsReverse"), this.getClient(), null);
    }

    @Nonnull
    public PassiveDnsRecordWithReferenceRequestBuilder passiveDnsReverse(@Nonnull String id) {
        return new PassiveDnsRecordWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("passiveDnsReverse") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public HostReputationRequestBuilder reputation() {
        return new HostReputationRequestBuilder(this.getRequestUrlWithAdditionalSegment("reputation"), this.getClient(), null);
    }

    @Nonnull
    public HostTrackerCollectionWithReferencesRequestBuilder trackers() {
        return new HostTrackerCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("trackers"), this.getClient(), null);
    }

    @Nonnull
    public HostTrackerWithReferenceRequestBuilder trackers(@Nonnull String id) {
        return new HostTrackerWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("trackers") + "/" + id, this.getClient(), null);
    }
}

