// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoverySearchPurgeDataRequest;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.PurgeType;
import com.microsoft.graph.security.models.PurgeAreas;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.security.models.EdiscoverySearchPurgeDataParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Search Purge Data Request Builder.
 */
public class EdiscoverySearchPurgeDataRequestBuilder extends BaseActionRequestBuilder<EdiscoverySearch> {

    /**
     * The request builder for this EdiscoverySearchPurgeData
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoverySearchPurgeDataRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private EdiscoverySearchPurgeDataParameterSet body;
    /**
     * The request builder for this EdiscoverySearchPurgeData
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public EdiscoverySearchPurgeDataRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final EdiscoverySearchPurgeDataParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the EdiscoverySearchPurgeDataRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoverySearchPurgeDataRequest instance
     */
    @Nonnull
    public EdiscoverySearchPurgeDataRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoverySearchPurgeDataRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoverySearchPurgeDataRequest instance
     */
    @Nonnull
    public EdiscoverySearchPurgeDataRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoverySearchPurgeDataRequest request = new EdiscoverySearchPurgeDataRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
