// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Presence;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.PresenceClearPresenceParameterSet;
import com.microsoft.graph.models.PresenceSetPresenceParameterSet;
import com.microsoft.graph.models.PresenceSetUserPreferredPresenceParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Presence Request Builder.
 */
public class PresenceRequestBuilder extends BaseRequestBuilder<Presence> {

    /**
     * The request builder for the Presence
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PresenceRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PresenceRequest instance
     */
    @Nonnull
    public PresenceRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PresenceRequest instance
     */
    @Nonnull
    public PresenceRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.PresenceRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public PresenceClearPresenceRequestBuilder clearPresence(@Nonnull final PresenceClearPresenceParameterSet parameters) {
        return new PresenceClearPresenceRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.clearPresence"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public PresenceClearUserPreferredPresenceRequestBuilder clearUserPreferredPresence() {
        return new PresenceClearUserPreferredPresenceRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.clearUserPreferredPresence"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public PresenceSetPresenceRequestBuilder setPresence(@Nonnull final PresenceSetPresenceParameterSet parameters) {
        return new PresenceSetPresenceRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.setPresence"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public PresenceSetUserPreferredPresenceRequestBuilder setUserPreferredPresence(@Nonnull final PresenceSetUserPreferredPresenceParameterSet parameters) {
        return new PresenceSetUserPreferredPresenceRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.setUserPreferredPresence"), getClient(), null, parameters);
    }
}
