// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MacOSLobApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mac OSLob App Request.
 */
public class MacOSLobAppRequest extends BaseRequest<MacOSLobApp> {
	
    /**
     * The request for the MacOSLobApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MacOSLobAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MacOSLobApp.class);
    }

    /**
     * Gets the MacOSLobApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSLobApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MacOSLobApp from the service
     *
     * @return the MacOSLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSLobApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSLobApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MacOSLobApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MacOSLobApp with a source
     *
     * @param sourceMacOSLobApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSLobApp> patchAsync(@Nonnull final MacOSLobApp sourceMacOSLobApp) {
        return sendAsync(HttpMethod.PATCH, sourceMacOSLobApp);
    }

    /**
     * Patches this MacOSLobApp with a source
     *
     * @param sourceMacOSLobApp the source object with updates
     * @return the updated MacOSLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSLobApp patch(@Nonnull final MacOSLobApp sourceMacOSLobApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceMacOSLobApp);
    }

    /**
     * Creates a MacOSLobApp with a new object
     *
     * @param newMacOSLobApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSLobApp> postAsync(@Nonnull final MacOSLobApp newMacOSLobApp) {
        return sendAsync(HttpMethod.POST, newMacOSLobApp);
    }

    /**
     * Creates a MacOSLobApp with a new object
     *
     * @param newMacOSLobApp the new object to create
     * @return the created MacOSLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSLobApp post(@Nonnull final MacOSLobApp newMacOSLobApp) throws ClientException {
        return send(HttpMethod.POST, newMacOSLobApp);
    }

    /**
     * Creates a MacOSLobApp with a new object
     *
     * @param newMacOSLobApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSLobApp> putAsync(@Nonnull final MacOSLobApp newMacOSLobApp) {
        return sendAsync(HttpMethod.PUT, newMacOSLobApp);
    }

    /**
     * Creates a MacOSLobApp with a new object
     *
     * @param newMacOSLobApp the object to create/update
     * @return the created MacOSLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSLobApp put(@Nonnull final MacOSLobApp newMacOSLobApp) throws ClientException {
        return send(HttpMethod.PUT, newMacOSLobApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MacOSLobAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MacOSLobAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

