// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;

import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AuditEventGetAuditCategoriesCollectionRequestBuilder;
import com.microsoft.graph.requests.AuditEventGetAuditCategoriesCollectionRequest;
import com.microsoft.graph.requests.AuditEventGetAuditCategoriesCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audit Event Get Audit Categories Collection Request Builder.
 */
public class AuditEventGetAuditCategoriesCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<String, AuditEventGetAuditCategoriesCollectionRequestBuilder, AuditEventGetAuditCategoriesCollectionResponse, AuditEventGetAuditCategoriesCollectionPage, AuditEventGetAuditCategoriesCollectionRequest> {

    /**
     * The request builder for this collection of AuditEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuditEventGetAuditCategoriesCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuditEventGetAuditCategoriesCollectionRequestBuilder.class, AuditEventGetAuditCategoriesCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AuditEventGetAuditCategoriesCollectionRequest instance
     */
    @Override
    @Nonnull
    public AuditEventGetAuditCategoriesCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AuditEventGetAuditCategoriesCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
