// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.SynchronizationError;
import com.microsoft.graph.models.QuarantineReason;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Quarantine.
 */
public class SynchronizationQuarantine implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Current Began.
     * 
     */
    @SerializedName(value = "currentBegan", alternate = {"CurrentBegan"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime currentBegan;

    /**
     * The Error.
     * 
     */
    @SerializedName(value = "error", alternate = {"Error"})
    @Expose
	@Nullable
    public SynchronizationError error;

    /**
     * The Next Attempt.
     * 
     */
    @SerializedName(value = "nextAttempt", alternate = {"NextAttempt"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime nextAttempt;

    /**
     * The Reason.
     * 
     */
    @SerializedName(value = "reason", alternate = {"Reason"})
    @Expose
	@Nullable
    public QuarantineReason reason;

    /**
     * The Series Began.
     * 
     */
    @SerializedName(value = "seriesBegan", alternate = {"SeriesBegan"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime seriesBegan;

    /**
     * The Series Count.
     * 
     */
    @SerializedName(value = "seriesCount", alternate = {"SeriesCount"})
    @Expose
	@Nullable
    public Long seriesCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
