/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.NoncustodialDataSource;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NoncustodialDataSourceReferenceRequest
extends BaseReferenceRequest<NoncustodialDataSource> {
    public NoncustodialDataSourceReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NoncustodialDataSource.class);
    }

    @Nonnull
    public NoncustodialDataSourceReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public NoncustodialDataSourceReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<NoncustodialDataSource> putAsync(@Nonnull NoncustodialDataSource srcNoncustodialDataSource) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/compliance/ediscovery/{id}/cases/{id}/noncustodialDataSources/" + srcNoncustodialDataSource.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public NoncustodialDataSource put(@Nonnull NoncustodialDataSource srcNoncustodialDataSource) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/compliance/ediscovery/{id}/cases/{id}/noncustodialDataSources/" + srcNoncustodialDataSource.id));
        return (NoncustodialDataSource)this.send(HttpMethod.PUT, payload);
    }
}

