// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Windows81CompliancePolicy;
import com.microsoft.graph.models.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.models.DeviceComplianceScheduledActionForRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows81Compliance Policy Request.
 */
public class Windows81CompliancePolicyRequest extends BaseRequest<Windows81CompliancePolicy> {
	
    /**
     * The request for the Windows81CompliancePolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Windows81CompliancePolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Windows81CompliancePolicy.class);
    }

    /**
     * Gets the Windows81CompliancePolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81CompliancePolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Windows81CompliancePolicy from the service
     *
     * @return the Windows81CompliancePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81CompliancePolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81CompliancePolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Windows81CompliancePolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Windows81CompliancePolicy with a source
     *
     * @param sourceWindows81CompliancePolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81CompliancePolicy> patchAsync(@Nonnull final Windows81CompliancePolicy sourceWindows81CompliancePolicy) {
        return sendAsync(HttpMethod.PATCH, sourceWindows81CompliancePolicy);
    }

    /**
     * Patches this Windows81CompliancePolicy with a source
     *
     * @param sourceWindows81CompliancePolicy the source object with updates
     * @return the updated Windows81CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81CompliancePolicy patch(@Nonnull final Windows81CompliancePolicy sourceWindows81CompliancePolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindows81CompliancePolicy);
    }

    /**
     * Creates a Windows81CompliancePolicy with a new object
     *
     * @param newWindows81CompliancePolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81CompliancePolicy> postAsync(@Nonnull final Windows81CompliancePolicy newWindows81CompliancePolicy) {
        return sendAsync(HttpMethod.POST, newWindows81CompliancePolicy);
    }

    /**
     * Creates a Windows81CompliancePolicy with a new object
     *
     * @param newWindows81CompliancePolicy the new object to create
     * @return the created Windows81CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81CompliancePolicy post(@Nonnull final Windows81CompliancePolicy newWindows81CompliancePolicy) throws ClientException {
        return send(HttpMethod.POST, newWindows81CompliancePolicy);
    }

    /**
     * Creates a Windows81CompliancePolicy with a new object
     *
     * @param newWindows81CompliancePolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81CompliancePolicy> putAsync(@Nonnull final Windows81CompliancePolicy newWindows81CompliancePolicy) {
        return sendAsync(HttpMethod.PUT, newWindows81CompliancePolicy);
    }

    /**
     * Creates a Windows81CompliancePolicy with a new object
     *
     * @param newWindows81CompliancePolicy the object to create/update
     * @return the created Windows81CompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81CompliancePolicy put(@Nonnull final Windows81CompliancePolicy newWindows81CompliancePolicy) throws ClientException {
        return send(HttpMethod.PUT, newWindows81CompliancePolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Windows81CompliancePolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Windows81CompliancePolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

