// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.WellknownListName;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.TodoTask;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ExtensionCollectionPage;
import com.microsoft.graph.requests.TodoTaskCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task List.
 */
public class TodoTaskList extends Entity implements IJsonBackedObject {


    /**
     * The Display Name.
     * The name of the task list.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Is Owner.
     * True if the user is owner of the given task list.
     */
    @SerializedName(value = "isOwner", alternate = {"IsOwner"})
    @Expose
	@Nullable
    public Boolean isOwner;

    /**
     * The Is Shared.
     * True if the task list is shared with other users
     */
    @SerializedName(value = "isShared", alternate = {"IsShared"})
    @Expose
	@Nullable
    public Boolean isShared;

    /**
     * The Wellknown List Name.
     * Property indicating the list name if the given list is a well-known list. Possible values are: none, defaultList, flaggedEmails, unknownFutureValue.
     */
    @SerializedName(value = "wellknownListName", alternate = {"WellknownListName"})
    @Expose
	@Nullable
    public WellknownListName wellknownListName;

    /**
     * The Extensions.
     * The collection of open extensions defined for the task list. Nullable.
     */
    @SerializedName(value = "extensions", alternate = {"Extensions"})
    @Expose
	@Nullable
    public ExtensionCollectionPage extensions;

    /**
     * The Tasks.
     * The tasks in this task list. Read-only. Nullable.
     */
    @SerializedName(value = "tasks", alternate = {"Tasks"})
    @Expose
	@Nullable
    public TodoTaskCollectionPage tasks;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("extensions")) {
            extensions = serializer.deserializeObject(json.get("extensions"), ExtensionCollectionPage.class);
        }

        if (json.has("tasks")) {
            tasks = serializer.deserializeObject(json.get("tasks"), TodoTaskCollectionPage.class);
        }
    }
}
