// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calculated Column.
 */
public class CalculatedColumn implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Format.
     * For dateTime output types, the format of the value. Must be one of dateOnly or dateTime.
     */
    @SerializedName(value = "format", alternate = {"Format"})
    @Expose
	@Nullable
    public String format;

    /**
     * The Formula.
     * The formula used to compute the value for this column.
     */
    @SerializedName(value = "formula", alternate = {"Formula"})
    @Expose
	@Nullable
    public String formula;

    /**
     * The Output Type.
     * The output type used to format values in this column. Must be one of boolean, currency, dateTime, number, or text.
     */
    @SerializedName(value = "outputType", alternate = {"OutputType"})
    @Expose
	@Nullable
    public String outputType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
