// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.Tag;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.ediscovery.requests.TagCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.ediscovery.requests.TagCollectionWithReferencesPage;
import com.microsoft.graph.ediscovery.requests.TagCollectionResponse;
import com.microsoft.graph.ediscovery.models.Tag;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tag Collection With References Page.
 */
public class TagCollectionWithReferencesPage extends BaseCollectionPage<Tag, TagCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for Tag
     *
     * @param response the serialized TagCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public TagCollectionWithReferencesPage(@Nonnull final TagCollectionResponse response, @Nullable final TagCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for Tag
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public TagCollectionWithReferencesPage(@Nonnull final java.util.List<Tag> pageContents, @Nullable final TagCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
