// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.Tag;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.ediscovery.requests.TagAsHierarchyCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.TagAsHierarchyCollectionRequest;
import com.microsoft.graph.ediscovery.requests.TagAsHierarchyCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tag As Hierarchy Collection Request Builder.
 */
public class TagAsHierarchyCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<Tag, TagAsHierarchyCollectionRequestBuilder, TagAsHierarchyCollectionResponse, TagAsHierarchyCollectionPage, TagAsHierarchyCollectionRequest> {

    /**
     * The request builder for this collection of Tag
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TagAsHierarchyCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TagAsHierarchyCollectionRequestBuilder.class, TagAsHierarchyCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the TagAsHierarchyCollectionRequest instance
     */
    @Override
    @Nonnull
    public TagAsHierarchyCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final TagAsHierarchyCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
