// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.SourceCollection;
import com.microsoft.graph.ediscovery.requests.DataSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.DataSourceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.DataSourceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.ediscovery.requests.DataSourceWithReferenceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.EstimateStatisticsOperationWithReferenceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Source Collection Request.
 */
public class SourceCollectionRequest extends BaseRequest<SourceCollection> {
	
    /**
     * The request for the SourceCollection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SourceCollectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SourceCollection.class);
    }

    /**
     * Gets the SourceCollection from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SourceCollection> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SourceCollection from the service
     *
     * @return the SourceCollection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SourceCollection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SourceCollection> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SourceCollection delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SourceCollection with a source
     *
     * @param sourceSourceCollection the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SourceCollection> patchAsync(@Nonnull final SourceCollection sourceSourceCollection) {
        return sendAsync(HttpMethod.PATCH, sourceSourceCollection);
    }

    /**
     * Patches this SourceCollection with a source
     *
     * @param sourceSourceCollection the source object with updates
     * @return the updated SourceCollection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SourceCollection patch(@Nonnull final SourceCollection sourceSourceCollection) throws ClientException {
        return send(HttpMethod.PATCH, sourceSourceCollection);
    }

    /**
     * Creates a SourceCollection with a new object
     *
     * @param newSourceCollection the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SourceCollection> postAsync(@Nonnull final SourceCollection newSourceCollection) {
        return sendAsync(HttpMethod.POST, newSourceCollection);
    }

    /**
     * Creates a SourceCollection with a new object
     *
     * @param newSourceCollection the new object to create
     * @return the created SourceCollection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SourceCollection post(@Nonnull final SourceCollection newSourceCollection) throws ClientException {
        return send(HttpMethod.POST, newSourceCollection);
    }

    /**
     * Creates a SourceCollection with a new object
     *
     * @param newSourceCollection the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SourceCollection> putAsync(@Nonnull final SourceCollection newSourceCollection) {
        return sendAsync(HttpMethod.PUT, newSourceCollection);
    }

    /**
     * Creates a SourceCollection with a new object
     *
     * @param newSourceCollection the object to create/update
     * @return the created SourceCollection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SourceCollection put(@Nonnull final SourceCollection newSourceCollection) throws ClientException {
        return send(HttpMethod.PUT, newSourceCollection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SourceCollectionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SourceCollectionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

