// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.NoncustodialDataSource;
import com.microsoft.graph.ediscovery.requests.DataSourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Noncustodial Data Source Request.
 */
public class NoncustodialDataSourceRequest extends BaseRequest<NoncustodialDataSource> {
	
    /**
     * The request for the NoncustodialDataSource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NoncustodialDataSourceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, NoncustodialDataSource.class);
    }

    /**
     * Gets the NoncustodialDataSource from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NoncustodialDataSource> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the NoncustodialDataSource from the service
     *
     * @return the NoncustodialDataSource from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NoncustodialDataSource get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NoncustodialDataSource> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public NoncustodialDataSource delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this NoncustodialDataSource with a source
     *
     * @param sourceNoncustodialDataSource the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NoncustodialDataSource> patchAsync(@Nonnull final NoncustodialDataSource sourceNoncustodialDataSource) {
        return sendAsync(HttpMethod.PATCH, sourceNoncustodialDataSource);
    }

    /**
     * Patches this NoncustodialDataSource with a source
     *
     * @param sourceNoncustodialDataSource the source object with updates
     * @return the updated NoncustodialDataSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NoncustodialDataSource patch(@Nonnull final NoncustodialDataSource sourceNoncustodialDataSource) throws ClientException {
        return send(HttpMethod.PATCH, sourceNoncustodialDataSource);
    }

    /**
     * Creates a NoncustodialDataSource with a new object
     *
     * @param newNoncustodialDataSource the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NoncustodialDataSource> postAsync(@Nonnull final NoncustodialDataSource newNoncustodialDataSource) {
        return sendAsync(HttpMethod.POST, newNoncustodialDataSource);
    }

    /**
     * Creates a NoncustodialDataSource with a new object
     *
     * @param newNoncustodialDataSource the new object to create
     * @return the created NoncustodialDataSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NoncustodialDataSource post(@Nonnull final NoncustodialDataSource newNoncustodialDataSource) throws ClientException {
        return send(HttpMethod.POST, newNoncustodialDataSource);
    }

    /**
     * Creates a NoncustodialDataSource with a new object
     *
     * @param newNoncustodialDataSource the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<NoncustodialDataSource> putAsync(@Nonnull final NoncustodialDataSource newNoncustodialDataSource) {
        return sendAsync(HttpMethod.PUT, newNoncustodialDataSource);
    }

    /**
     * Creates a NoncustodialDataSource with a new object
     *
     * @param newNoncustodialDataSource the object to create/update
     * @return the created NoncustodialDataSource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public NoncustodialDataSource put(@Nonnull final NoncustodialDataSource newNoncustodialDataSource) throws ClientException {
        return send(HttpMethod.PUT, newNoncustodialDataSource);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public NoncustodialDataSourceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public NoncustodialDataSourceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

