// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.SourceCollection;
import com.microsoft.graph.ediscovery.models.NoncustodialDataSource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceCollectionWithReferencesPage;
import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceCollectionResponse;
import com.microsoft.graph.ediscovery.models.NoncustodialDataSource;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Noncustodial Data Source Collection With References Page.
 */
public class NoncustodialDataSourceCollectionWithReferencesPage extends BaseCollectionPage<NoncustodialDataSource, NoncustodialDataSourceCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for NoncustodialDataSource
     *
     * @param response the serialized NoncustodialDataSourceCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public NoncustodialDataSourceCollectionWithReferencesPage(@Nonnull final NoncustodialDataSourceCollectionResponse response, @Nullable final NoncustodialDataSourceCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for NoncustodialDataSource
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public NoncustodialDataSourceCollectionWithReferencesPage(@Nonnull final java.util.List<NoncustodialDataSource> pageContents, @Nullable final NoncustodialDataSourceCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
