// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.CaseOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Case Operation Request.
 */
public class CaseOperationRequest extends BaseRequest<CaseOperation> {
	
    /**
     * The request for the CaseOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public CaseOperationRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends CaseOperation> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the CaseOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CaseOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CaseOperation.class);
    }

    /**
     * Gets the CaseOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CaseOperation from the service
     *
     * @return the CaseOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CaseOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CaseOperation with a source
     *
     * @param sourceCaseOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseOperation> patchAsync(@Nonnull final CaseOperation sourceCaseOperation) {
        return sendAsync(HttpMethod.PATCH, sourceCaseOperation);
    }

    /**
     * Patches this CaseOperation with a source
     *
     * @param sourceCaseOperation the source object with updates
     * @return the updated CaseOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseOperation patch(@Nonnull final CaseOperation sourceCaseOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceCaseOperation);
    }

    /**
     * Creates a CaseOperation with a new object
     *
     * @param newCaseOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseOperation> postAsync(@Nonnull final CaseOperation newCaseOperation) {
        return sendAsync(HttpMethod.POST, newCaseOperation);
    }

    /**
     * Creates a CaseOperation with a new object
     *
     * @param newCaseOperation the new object to create
     * @return the created CaseOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseOperation post(@Nonnull final CaseOperation newCaseOperation) throws ClientException {
        return send(HttpMethod.POST, newCaseOperation);
    }

    /**
     * Creates a CaseOperation with a new object
     *
     * @param newCaseOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseOperation> putAsync(@Nonnull final CaseOperation newCaseOperation) {
        return sendAsync(HttpMethod.PUT, newCaseOperation);
    }

    /**
     * Creates a CaseOperation with a new object
     *
     * @param newCaseOperation the object to create/update
     * @return the created CaseOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseOperation put(@Nonnull final CaseOperation newCaseOperation) throws ClientException {
        return send(HttpMethod.PUT, newCaseOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CaseOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CaseOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

