/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Edge;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EdgeRequest
extends BaseRequest<Edge> {
    public EdgeRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Edge.class);
    }

    @Nonnull
    public CompletableFuture<Edge> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Edge get() throws ClientException {
        return (Edge)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Edge> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Edge delete() throws ClientException {
        return (Edge)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Edge> patchAsync(@Nonnull Edge sourceEdge) {
        return this.sendAsync(HttpMethod.PATCH, sourceEdge);
    }

    @Nullable
    public Edge patch(@Nonnull Edge sourceEdge) throws ClientException {
        return (Edge)this.send(HttpMethod.PATCH, sourceEdge);
    }

    @Nonnull
    public CompletableFuture<Edge> postAsync(@Nonnull Edge newEdge) {
        return this.sendAsync(HttpMethod.POST, newEdge);
    }

    @Nullable
    public Edge post(@Nonnull Edge newEdge) throws ClientException {
        return (Edge)this.send(HttpMethod.POST, newEdge);
    }

    @Nonnull
    public CompletableFuture<Edge> putAsync(@Nonnull Edge newEdge) {
        return this.sendAsync(HttpMethod.PUT, newEdge);
    }

    @Nullable
    public Edge put(@Nonnull Edge newEdge) throws ClientException {
        return (Edge)this.send(HttpMethod.PUT, newEdge);
    }

    @Nonnull
    public EdgeRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public EdgeRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

