// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AgreementAcceptance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Acceptance Request.
 */
public class AgreementAcceptanceRequest extends BaseRequest<AgreementAcceptance> {
	
    /**
     * The request for the AgreementAcceptance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementAcceptanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementAcceptance.class);
    }

    /**
     * Gets the AgreementAcceptance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementAcceptance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AgreementAcceptance from the service
     *
     * @return the AgreementAcceptance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementAcceptance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementAcceptance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AgreementAcceptance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AgreementAcceptance with a source
     *
     * @param sourceAgreementAcceptance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementAcceptance> patchAsync(@Nonnull final AgreementAcceptance sourceAgreementAcceptance) {
        return sendAsync(HttpMethod.PATCH, sourceAgreementAcceptance);
    }

    /**
     * Patches this AgreementAcceptance with a source
     *
     * @param sourceAgreementAcceptance the source object with updates
     * @return the updated AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementAcceptance patch(@Nonnull final AgreementAcceptance sourceAgreementAcceptance) throws ClientException {
        return send(HttpMethod.PATCH, sourceAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementAcceptance> postAsync(@Nonnull final AgreementAcceptance newAgreementAcceptance) {
        return sendAsync(HttpMethod.POST, newAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the new object to create
     * @return the created AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementAcceptance post(@Nonnull final AgreementAcceptance newAgreementAcceptance) throws ClientException {
        return send(HttpMethod.POST, newAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementAcceptance> putAsync(@Nonnull final AgreementAcceptance newAgreementAcceptance) {
        return sendAsync(HttpMethod.PUT, newAgreementAcceptance);
    }

    /**
     * Creates a AgreementAcceptance with a new object
     *
     * @param newAgreementAcceptance the object to create/update
     * @return the created AgreementAcceptance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementAcceptance put(@Nonnull final AgreementAcceptance newAgreementAcceptance) throws ClientException {
        return send(HttpMethod.PUT, newAgreementAcceptance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AgreementAcceptanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AgreementAcceptanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

