// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.models.ItemReference;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ContentTypeCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionWithReferencesPage;
import com.microsoft.graph.requests.ContentTypeCollectionResponse;
import com.microsoft.graph.models.ContentType;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Collection With References Page.
 */
public class ContentTypeCollectionWithReferencesPage extends BaseCollectionPage<ContentType, ContentTypeCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for ContentType
     *
     * @param response the serialized ContentTypeCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ContentTypeCollectionWithReferencesPage(@Nonnull final ContentTypeCollectionResponse response, @Nullable final ContentTypeCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for ContentType
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ContentTypeCollectionWithReferencesPage(@Nonnull final java.util.List<ContentType> pageContents, @Nullable final ContentTypeCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
