// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AllowedValueCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Security Attribute Definition.
 */
public class CustomSecurityAttributeDefinition extends Entity implements IJsonBackedObject {


    /**
     * The Attribute Set.
     * 
     */
    @SerializedName(value = "attributeSet", alternate = {"AttributeSet"})
    @Expose
	@Nullable
    public String attributeSet;

    /**
     * The Description.
     * 
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Is Collection.
     * 
     */
    @SerializedName(value = "isCollection", alternate = {"IsCollection"})
    @Expose
	@Nullable
    public Boolean isCollection;

    /**
     * The Is Searchable.
     * 
     */
    @SerializedName(value = "isSearchable", alternate = {"IsSearchable"})
    @Expose
	@Nullable
    public Boolean isSearchable;

    /**
     * The Name.
     * 
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Status.
     * 
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public String status;

    /**
     * The Type.
     * 
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
	@Nullable
    public String type;

    /**
     * The Use Pre Defined Values Only.
     * 
     */
    @SerializedName(value = "usePreDefinedValuesOnly", alternate = {"UsePreDefinedValuesOnly"})
    @Expose
	@Nullable
    public Boolean usePreDefinedValuesOnly;

    /**
     * The Allowed Values.
     * 
     */
    @SerializedName(value = "allowedValues", alternate = {"AllowedValues"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AllowedValueCollectionPage allowedValues;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("allowedValues")) {
            allowedValues = serializer.deserializeObject(json.get("allowedValues"), com.microsoft.graph.requests.AllowedValueCollectionPage.class);
        }
    }
}
