// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PrintSettings;
import com.microsoft.graph.requests.PrintConnectorCollectionPage;
import com.microsoft.graph.requests.PrintOperationCollectionPage;
import com.microsoft.graph.requests.PrinterCollectionPage;
import com.microsoft.graph.requests.PrintServiceCollectionPage;
import com.microsoft.graph.requests.PrinterShareCollectionPage;
import com.microsoft.graph.requests.PrintTaskDefinitionCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print.
 */
public class Print implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Settings.
     * Tenant-wide settings for the Universal Print service.
     */
    @SerializedName(value = "settings", alternate = {"Settings"})
    @Expose
	@Nullable
    public PrintSettings settings;

    /**
     * The Connectors.
     * The list of available print connectors.
     */
    @SerializedName(value = "connectors", alternate = {"Connectors"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintConnectorCollectionPage connectors;

    /**
     * The Operations.
     * The list of print long running operations.
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintOperationCollectionPage operations;

    /**
     * The Printers.
     * The list of printers registered in the tenant.
     */
    @SerializedName(value = "printers", alternate = {"Printers"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrinterCollectionPage printers;

    /**
     * The Services.
     * The list of available Universal Print service endpoints.
     */
    @SerializedName(value = "services", alternate = {"Services"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintServiceCollectionPage services;

    /**
     * The Shares.
     * The list of printer shares registered in the tenant.
     */
    @SerializedName(value = "shares", alternate = {"Shares"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrinterShareCollectionPage shares;

    /**
     * The Task Definitions.
     * List of abstract definition for a task that can be triggered when various events occur within Universal Print.
     */
    @SerializedName(value = "taskDefinitions", alternate = {"TaskDefinitions"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PrintTaskDefinitionCollectionPage taskDefinitions;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("connectors")) {
            connectors = serializer.deserializeObject(json.get("connectors"), com.microsoft.graph.requests.PrintConnectorCollectionPage.class);
        }

        if (json.has("operations")) {
            operations = serializer.deserializeObject(json.get("operations"), com.microsoft.graph.requests.PrintOperationCollectionPage.class);
        }

        if (json.has("printers")) {
            printers = serializer.deserializeObject(json.get("printers"), com.microsoft.graph.requests.PrinterCollectionPage.class);
        }

        if (json.has("services")) {
            services = serializer.deserializeObject(json.get("services"), com.microsoft.graph.requests.PrintServiceCollectionPage.class);
        }

        if (json.has("shares")) {
            shares = serializer.deserializeObject(json.get("shares"), com.microsoft.graph.requests.PrinterShareCollectionPage.class);
        }

        if (json.has("taskDefinitions")) {
            taskDefinitions = serializer.deserializeObject(json.get("taskDefinitions"), com.microsoft.graph.requests.PrintTaskDefinitionCollectionPage.class);
        }
    }
}
