// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AnswerInputType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Question Answer.
 */
public class BookingQuestionAnswer implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Answer.
     * The answer given by the user in case the answerInputType is text.
     */
    @SerializedName(value = "answer", alternate = {"Answer"})
    @Expose
	@Nullable
    public String answer;

    /**
     * The Answer Input Type.
     * The expected answer type. The possible values are: text, radioButton, unknownFutureValue.
     */
    @SerializedName(value = "answerInputType", alternate = {"AnswerInputType"})
    @Expose
	@Nullable
    public AnswerInputType answerInputType;

    /**
     * The Answer Options.
     * In case the answerInputType is radioButton, this will consists of a list of possible answer values.
     */
    @SerializedName(value = "answerOptions", alternate = {"AnswerOptions"})
    @Expose
	@Nullable
    public java.util.List<String> answerOptions;

    /**
     * The Is Required.
     * Indicates whether it is mandatory to answer the custom question.
     */
    @SerializedName(value = "isRequired", alternate = {"IsRequired"})
    @Expose
	@Nullable
    public Boolean isRequired;

    /**
     * The Question.
     * The question.
     */
    @SerializedName(value = "question", alternate = {"Question"})
    @Expose
	@Nullable
    public String question;

    /**
     * The Question Id.
     * The ID of the custom question.
     */
    @SerializedName(value = "questionId", alternate = {"QuestionId"})
    @Expose
	@Nullable
    public String questionId;

    /**
     * The Selected Options.
     * The answers selected by the user.
     */
    @SerializedName(value = "selectedOptions", alternate = {"SelectedOptions"})
    @Expose
	@Nullable
    public java.util.List<String> selectedOptions;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
