// Template Source: BaseEntityCollectionReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Printer;
import com.microsoft.graph.models.PrinterShare;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.PrinterShareWithReferenceRequest;
import com.microsoft.graph.requests.PrinterShareReferenceRequestBuilder;
import com.microsoft.graph.requests.PrinterShareWithReferenceRequestBuilder;
import com.microsoft.graph.requests.PrinterShareCollectionWithReferencesRequest;
import com.microsoft.graph.requests.PrinterShareCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.http.ReferenceRequestBody;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Share Collection Reference Request.
 */
public class PrinterShareCollectionReferenceRequest extends BaseCollectionWithReferencesRequest<PrinterShare, PrinterShareWithReferenceRequest, PrinterShareReferenceRequestBuilder, PrinterShareWithReferenceRequestBuilder, PrinterShareCollectionResponse, PrinterShareCollectionWithReferencesPage, PrinterShareCollectionWithReferencesRequest> {

    /**
     * The request builder for this collection of PrinterShare
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterShareCollectionReferenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterShareCollectionResponse.class, PrinterShareCollectionWithReferencesPage.class, PrinterShareCollectionWithReferencesRequestBuilder.class);
    }

    /**
     * Creates a new PrinterShare
     * @param newPrinterShare the PrinterShare to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterShare> postAsync(@Nonnull final PrinterShare newPrinterShare) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/print/shares/" + newPrinterShare.id);
        return new PrinterShareWithReferenceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newPrinterShare, body);
    }

    /**
     * Creates a new PrinterShare
     * @param newPrinterShare the PrinterShare to create
     * @return the newly created object
     */
    @Nonnull
    public PrinterShare post(@Nonnull final PrinterShare newPrinterShare) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/print/shares/" + newPrinterShare.id);
        return new PrinterShareWithReferenceRequestBuilder(requestUrl,getBaseRequest().getClient(), /* Options */ null)
                .buildRequest(getBaseRequest().getHeaders())
                .post(newPrinterShare, body);
    }
    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public PrinterShareCollectionReferenceRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public PrinterShareCollectionReferenceRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the sort clause
     * @return the updated request
     */
    @Nonnull
    public PrinterShareCollectionReferenceRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public PrinterShareCollectionReferenceRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public PrinterShareCollectionReferenceRequest top(final int value) {
        addTopOption(value);
        return this;
    }
    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public PrinterShareCollectionReferenceRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public PrinterShareCollectionReferenceRequest count() {
        addCountOption(true);
        return this;
    }
}
