// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Device;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Request.
 */
public class DeviceRequest extends BaseRequest<Device> {
	
    /**
     * The request for the Device
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Device.class);
    }

    /**
     * Gets the Device from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Device> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Device from the service
     *
     * @return the Device from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Device get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Device> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Device delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Device with a source
     *
     * @param sourceDevice the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Device> patchAsync(@Nonnull final Device sourceDevice) {
        return sendAsync(HttpMethod.PATCH, sourceDevice);
    }

    /**
     * Patches this Device with a source
     *
     * @param sourceDevice the source object with updates
     * @return the updated Device
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Device patch(@Nonnull final Device sourceDevice) throws ClientException {
        return send(HttpMethod.PATCH, sourceDevice);
    }

    /**
     * Creates a Device with a new object
     *
     * @param newDevice the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Device> postAsync(@Nonnull final Device newDevice) {
        return sendAsync(HttpMethod.POST, newDevice);
    }

    /**
     * Creates a Device with a new object
     *
     * @param newDevice the new object to create
     * @return the created Device
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Device post(@Nonnull final Device newDevice) throws ClientException {
        return send(HttpMethod.POST, newDevice);
    }

    /**
     * Creates a Device with a new object
     *
     * @param newDevice the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Device> putAsync(@Nonnull final Device newDevice) {
        return sendAsync(HttpMethod.PUT, newDevice);
    }

    /**
     * Creates a Device with a new object
     *
     * @param newDevice the object to create/update
     * @return the created Device
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Device put(@Nonnull final Device newDevice) throws ClientException {
        return send(HttpMethod.PUT, newDevice);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

