// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AppConsentApprovalRoute;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Consent Approval Route Request.
 */
public class AppConsentApprovalRouteRequest extends BaseRequest<AppConsentApprovalRoute> {
	
    /**
     * The request for the AppConsentApprovalRoute
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppConsentApprovalRouteRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppConsentApprovalRoute.class);
    }

    /**
     * Gets the AppConsentApprovalRoute from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentApprovalRoute> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AppConsentApprovalRoute from the service
     *
     * @return the AppConsentApprovalRoute from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentApprovalRoute get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentApprovalRoute> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AppConsentApprovalRoute delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AppConsentApprovalRoute with a source
     *
     * @param sourceAppConsentApprovalRoute the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentApprovalRoute> patchAsync(@Nonnull final AppConsentApprovalRoute sourceAppConsentApprovalRoute) {
        return sendAsync(HttpMethod.PATCH, sourceAppConsentApprovalRoute);
    }

    /**
     * Patches this AppConsentApprovalRoute with a source
     *
     * @param sourceAppConsentApprovalRoute the source object with updates
     * @return the updated AppConsentApprovalRoute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentApprovalRoute patch(@Nonnull final AppConsentApprovalRoute sourceAppConsentApprovalRoute) throws ClientException {
        return send(HttpMethod.PATCH, sourceAppConsentApprovalRoute);
    }

    /**
     * Creates a AppConsentApprovalRoute with a new object
     *
     * @param newAppConsentApprovalRoute the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentApprovalRoute> postAsync(@Nonnull final AppConsentApprovalRoute newAppConsentApprovalRoute) {
        return sendAsync(HttpMethod.POST, newAppConsentApprovalRoute);
    }

    /**
     * Creates a AppConsentApprovalRoute with a new object
     *
     * @param newAppConsentApprovalRoute the new object to create
     * @return the created AppConsentApprovalRoute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentApprovalRoute post(@Nonnull final AppConsentApprovalRoute newAppConsentApprovalRoute) throws ClientException {
        return send(HttpMethod.POST, newAppConsentApprovalRoute);
    }

    /**
     * Creates a AppConsentApprovalRoute with a new object
     *
     * @param newAppConsentApprovalRoute the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentApprovalRoute> putAsync(@Nonnull final AppConsentApprovalRoute newAppConsentApprovalRoute) {
        return sendAsync(HttpMethod.PUT, newAppConsentApprovalRoute);
    }

    /**
     * Creates a AppConsentApprovalRoute with a new object
     *
     * @param newAppConsentApprovalRoute the object to create/update
     * @return the created AppConsentApprovalRoute
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentApprovalRoute put(@Nonnull final AppConsentApprovalRoute newAppConsentApprovalRoute) throws ClientException {
        return send(HttpMethod.PUT, newAppConsentApprovalRoute);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AppConsentApprovalRouteRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AppConsentApprovalRouteRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

