// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsAutopilotDeviceIdentity;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Autopilot Device Identity Request.
 */
public class WindowsAutopilotDeviceIdentityRequest extends BaseRequest<WindowsAutopilotDeviceIdentity> {
	
    /**
     * The request for the WindowsAutopilotDeviceIdentity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsAutopilotDeviceIdentityRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsAutopilotDeviceIdentity.class);
    }

    /**
     * Gets the WindowsAutopilotDeviceIdentity from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAutopilotDeviceIdentity> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsAutopilotDeviceIdentity from the service
     *
     * @return the WindowsAutopilotDeviceIdentity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAutopilotDeviceIdentity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAutopilotDeviceIdentity> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsAutopilotDeviceIdentity delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsAutopilotDeviceIdentity with a source
     *
     * @param sourceWindowsAutopilotDeviceIdentity the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAutopilotDeviceIdentity> patchAsync(@Nonnull final WindowsAutopilotDeviceIdentity sourceWindowsAutopilotDeviceIdentity) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsAutopilotDeviceIdentity);
    }

    /**
     * Patches this WindowsAutopilotDeviceIdentity with a source
     *
     * @param sourceWindowsAutopilotDeviceIdentity the source object with updates
     * @return the updated WindowsAutopilotDeviceIdentity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAutopilotDeviceIdentity patch(@Nonnull final WindowsAutopilotDeviceIdentity sourceWindowsAutopilotDeviceIdentity) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a WindowsAutopilotDeviceIdentity with a new object
     *
     * @param newWindowsAutopilotDeviceIdentity the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAutopilotDeviceIdentity> postAsync(@Nonnull final WindowsAutopilotDeviceIdentity newWindowsAutopilotDeviceIdentity) {
        return sendAsync(HttpMethod.POST, newWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a WindowsAutopilotDeviceIdentity with a new object
     *
     * @param newWindowsAutopilotDeviceIdentity the new object to create
     * @return the created WindowsAutopilotDeviceIdentity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAutopilotDeviceIdentity post(@Nonnull final WindowsAutopilotDeviceIdentity newWindowsAutopilotDeviceIdentity) throws ClientException {
        return send(HttpMethod.POST, newWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a WindowsAutopilotDeviceIdentity with a new object
     *
     * @param newWindowsAutopilotDeviceIdentity the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsAutopilotDeviceIdentity> putAsync(@Nonnull final WindowsAutopilotDeviceIdentity newWindowsAutopilotDeviceIdentity) {
        return sendAsync(HttpMethod.PUT, newWindowsAutopilotDeviceIdentity);
    }

    /**
     * Creates a WindowsAutopilotDeviceIdentity with a new object
     *
     * @param newWindowsAutopilotDeviceIdentity the object to create/update
     * @return the created WindowsAutopilotDeviceIdentity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsAutopilotDeviceIdentity put(@Nonnull final WindowsAutopilotDeviceIdentity newWindowsAutopilotDeviceIdentity) throws ClientException {
        return send(HttpMethod.PUT, newWindowsAutopilotDeviceIdentity);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsAutopilotDeviceIdentityRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsAutopilotDeviceIdentityRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

