// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Security;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Security Request Builder.
 */
public class SecurityRequestBuilder extends BaseRequestBuilder<Security> {

    /**
     * The request builder for the Security
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SecurityRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the SecurityRequest instance
     */
    @Nonnull
    public SecurityRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the SecurityRequest instance
     */
    @Nonnull
    public SecurityRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.SecurityRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for CasesRoot
     *
     * @return the CasesRootRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.security.requests.CasesRootRequestBuilder cases() {
        return new com.microsoft.graph.security.requests.CasesRootRequestBuilder(getRequestUrlWithAdditionalSegment("cases"), getClient(), null);
    }

    /**
     * Gets the request builder for AttackSimulationRoot
     *
     * @return the AttackSimulationRootRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.AttackSimulationRootRequestBuilder attackSimulation() {
        return new com.microsoft.graph.requests.AttackSimulationRootRequestBuilder(getRequestUrlWithAdditionalSegment("attackSimulation"), getClient(), null);
    }
    /**
     *  Gets a request builder for the Alert collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AlertCollectionRequestBuilder alerts() {
        return new com.microsoft.graph.requests.AlertCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("alerts"), getClient(), null);
    }

    /**
     * Gets a request builder for the Alert item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AlertRequestBuilder alerts(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AlertRequestBuilder(getRequestUrlWithAdditionalSegment("alerts") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the SecureScoreControlProfile collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.SecureScoreControlProfileCollectionRequestBuilder secureScoreControlProfiles() {
        return new com.microsoft.graph.requests.SecureScoreControlProfileCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("secureScoreControlProfiles"), getClient(), null);
    }

    /**
     * Gets a request builder for the SecureScoreControlProfile item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.SecureScoreControlProfileRequestBuilder secureScoreControlProfiles(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SecureScoreControlProfileRequestBuilder(getRequestUrlWithAdditionalSegment("secureScoreControlProfiles") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the SecureScore collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.SecureScoreCollectionRequestBuilder secureScores() {
        return new com.microsoft.graph.requests.SecureScoreCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("secureScores"), getClient(), null);
    }

    /**
     * Gets a request builder for the SecureScore item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.SecureScoreRequestBuilder secureScores(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SecureScoreRequestBuilder(getRequestUrlWithAdditionalSegment("secureScores") + "/" + id, getClient(), null);
    }
}
