// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RbacApplication;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Rbac Application Request Builder.
 */
public class RbacApplicationRequestBuilder extends BaseRequestBuilder<RbacApplication> {

    /**
     * The request builder for the RbacApplication
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RbacApplicationRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the RbacApplicationRequest instance
     */
    @Nonnull
    public RbacApplicationRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the RbacApplicationRequest instance
     */
    @Nonnull
    public RbacApplicationRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.RbacApplicationRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the UnifiedRoleAssignment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentCollectionRequestBuilder roleAssignments() {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignments"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleAssignment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentRequestBuilder roleAssignments(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignments") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleDefinition collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleDefinitionCollectionRequestBuilder roleDefinitions() {
        return new com.microsoft.graph.requests.UnifiedRoleDefinitionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleDefinitions"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleDefinition item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleDefinitionRequestBuilder roleDefinitions(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleDefinitionRequestBuilder(getRequestUrlWithAdditionalSegment("roleDefinitions") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleAssignmentScheduleInstance collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleInstanceCollectionRequestBuilder roleAssignmentScheduleInstances() {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleInstanceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignmentScheduleInstances"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleAssignmentScheduleInstance item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleInstanceRequestBuilder roleAssignmentScheduleInstances(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleInstanceRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignmentScheduleInstances") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleAssignmentScheduleRequest collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestCollectionRequestBuilder roleAssignmentScheduleRequests() {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignmentScheduleRequests"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleAssignmentScheduleRequest item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestRequestBuilder roleAssignmentScheduleRequests(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignmentScheduleRequests") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleAssignmentSchedule collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleCollectionRequestBuilder roleAssignmentSchedules() {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignmentSchedules"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleAssignmentSchedule item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestBuilder roleAssignmentSchedules(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleRequestBuilder(getRequestUrlWithAdditionalSegment("roleAssignmentSchedules") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleEligibilityScheduleInstance collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleInstanceCollectionRequestBuilder roleEligibilityScheduleInstances() {
        return new com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleInstanceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleEligibilityScheduleInstances"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleEligibilityScheduleInstance item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleInstanceRequestBuilder roleEligibilityScheduleInstances(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleInstanceRequestBuilder(getRequestUrlWithAdditionalSegment("roleEligibilityScheduleInstances") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleEligibilityScheduleRequest collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestCollectionRequestBuilder roleEligibilityScheduleRequests() {
        return new com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleEligibilityScheduleRequests"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleEligibilityScheduleRequest item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestRequestBuilder roleEligibilityScheduleRequests(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestRequestBuilder(getRequestUrlWithAdditionalSegment("roleEligibilityScheduleRequests") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleEligibilitySchedule collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleCollectionRequestBuilder roleEligibilitySchedules() {
        return new com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleEligibilitySchedules"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleEligibilitySchedule item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestBuilder roleEligibilitySchedules(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleRequestBuilder(getRequestUrlWithAdditionalSegment("roleEligibilitySchedules") + "/" + id, getClient(), null);
    }
}
