// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceManagementReports;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.DeviceManagementReportsGetCachedReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetCompliancePolicyNonComplianceReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetCompliancePolicyNonComplianceSummaryReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetComplianceSettingNonComplianceReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetConfigurationPolicyNonComplianceReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetConfigurationPolicyNonComplianceSummaryReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetConfigurationSettingNonComplianceReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetDeviceManagementIntentPerSettingContributingProfilesParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetDeviceManagementIntentSettingsReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetDeviceNonComplianceReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetHistoricalReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetNoncompliantDevicesAndSettingsReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetPolicyNonComplianceMetadataParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetPolicyNonComplianceReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetPolicyNonComplianceSummaryReportParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetReportFiltersParameterSet;
import com.microsoft.graph.models.DeviceManagementReportsGetSettingNonComplianceReportParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Reports Request Builder.
 */
public class DeviceManagementReportsRequestBuilder extends BaseRequestBuilder<DeviceManagementReports> {

    /**
     * The request builder for the DeviceManagementReports
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceManagementReportsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the DeviceManagementReportsRequest instance
     */
    @Nonnull
    public DeviceManagementReportsRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the DeviceManagementReportsRequest instance
     */
    @Nonnull
    public DeviceManagementReportsRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.DeviceManagementReportsRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the DeviceManagementExportJob collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DeviceManagementExportJobCollectionRequestBuilder exportJobs() {
        return new com.microsoft.graph.requests.DeviceManagementExportJobCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("exportJobs"), getClient(), null);
    }

    /**
     * Gets a request builder for the DeviceManagementExportJob item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DeviceManagementExportJobRequestBuilder exportJobs(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DeviceManagementExportJobRequestBuilder(getRequestUrlWithAdditionalSegment("exportJobs") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetCachedReportRequestBuilder getCachedReport(@Nonnull final DeviceManagementReportsGetCachedReportParameterSet parameters) {
        return new DeviceManagementReportsGetCachedReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getCachedReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetCompliancePolicyNonComplianceReportRequestBuilder getCompliancePolicyNonComplianceReport(@Nonnull final DeviceManagementReportsGetCompliancePolicyNonComplianceReportParameterSet parameters) {
        return new DeviceManagementReportsGetCompliancePolicyNonComplianceReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getCompliancePolicyNonComplianceReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetCompliancePolicyNonComplianceSummaryReportRequestBuilder getCompliancePolicyNonComplianceSummaryReport(@Nonnull final DeviceManagementReportsGetCompliancePolicyNonComplianceSummaryReportParameterSet parameters) {
        return new DeviceManagementReportsGetCompliancePolicyNonComplianceSummaryReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getCompliancePolicyNonComplianceSummaryReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetComplianceSettingNonComplianceReportRequestBuilder getComplianceSettingNonComplianceReport(@Nonnull final DeviceManagementReportsGetComplianceSettingNonComplianceReportParameterSet parameters) {
        return new DeviceManagementReportsGetComplianceSettingNonComplianceReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getComplianceSettingNonComplianceReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetConfigurationPolicyNonComplianceReportRequestBuilder getConfigurationPolicyNonComplianceReport(@Nonnull final DeviceManagementReportsGetConfigurationPolicyNonComplianceReportParameterSet parameters) {
        return new DeviceManagementReportsGetConfigurationPolicyNonComplianceReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getConfigurationPolicyNonComplianceReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetConfigurationPolicyNonComplianceSummaryReportRequestBuilder getConfigurationPolicyNonComplianceSummaryReport(@Nonnull final DeviceManagementReportsGetConfigurationPolicyNonComplianceSummaryReportParameterSet parameters) {
        return new DeviceManagementReportsGetConfigurationPolicyNonComplianceSummaryReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getConfigurationPolicyNonComplianceSummaryReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetConfigurationSettingNonComplianceReportRequestBuilder getConfigurationSettingNonComplianceReport(@Nonnull final DeviceManagementReportsGetConfigurationSettingNonComplianceReportParameterSet parameters) {
        return new DeviceManagementReportsGetConfigurationSettingNonComplianceReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getConfigurationSettingNonComplianceReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetDeviceManagementIntentPerSettingContributingProfilesRequestBuilder getDeviceManagementIntentPerSettingContributingProfiles(@Nonnull final DeviceManagementReportsGetDeviceManagementIntentPerSettingContributingProfilesParameterSet parameters) {
        return new DeviceManagementReportsGetDeviceManagementIntentPerSettingContributingProfilesRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getDeviceManagementIntentPerSettingContributingProfiles"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetDeviceManagementIntentSettingsReportRequestBuilder getDeviceManagementIntentSettingsReport(@Nonnull final DeviceManagementReportsGetDeviceManagementIntentSettingsReportParameterSet parameters) {
        return new DeviceManagementReportsGetDeviceManagementIntentSettingsReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getDeviceManagementIntentSettingsReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetDeviceNonComplianceReportRequestBuilder getDeviceNonComplianceReport(@Nonnull final DeviceManagementReportsGetDeviceNonComplianceReportParameterSet parameters) {
        return new DeviceManagementReportsGetDeviceNonComplianceReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getDeviceNonComplianceReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetHistoricalReportRequestBuilder getHistoricalReport(@Nonnull final DeviceManagementReportsGetHistoricalReportParameterSet parameters) {
        return new DeviceManagementReportsGetHistoricalReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getHistoricalReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetNoncompliantDevicesAndSettingsReportRequestBuilder getNoncompliantDevicesAndSettingsReport(@Nonnull final DeviceManagementReportsGetNoncompliantDevicesAndSettingsReportParameterSet parameters) {
        return new DeviceManagementReportsGetNoncompliantDevicesAndSettingsReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getNoncompliantDevicesAndSettingsReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetPolicyNonComplianceMetadataRequestBuilder getPolicyNonComplianceMetadata(@Nonnull final DeviceManagementReportsGetPolicyNonComplianceMetadataParameterSet parameters) {
        return new DeviceManagementReportsGetPolicyNonComplianceMetadataRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getPolicyNonComplianceMetadata"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetPolicyNonComplianceReportRequestBuilder getPolicyNonComplianceReport(@Nonnull final DeviceManagementReportsGetPolicyNonComplianceReportParameterSet parameters) {
        return new DeviceManagementReportsGetPolicyNonComplianceReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getPolicyNonComplianceReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetPolicyNonComplianceSummaryReportRequestBuilder getPolicyNonComplianceSummaryReport(@Nonnull final DeviceManagementReportsGetPolicyNonComplianceSummaryReportParameterSet parameters) {
        return new DeviceManagementReportsGetPolicyNonComplianceSummaryReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getPolicyNonComplianceSummaryReport"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetReportFiltersRequestBuilder getReportFilters(@Nonnull final DeviceManagementReportsGetReportFiltersParameterSet parameters) {
        return new DeviceManagementReportsGetReportFiltersRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getReportFilters"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DeviceManagementReportsGetSettingNonComplianceReportRequestBuilder getSettingNonComplianceReport(@Nonnull final DeviceManagementReportsGetSettingNonComplianceReportParameterSet parameters) {
        return new DeviceManagementReportsGetSettingNonComplianceReportRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSettingNonComplianceReport"), getClient(), null, parameters);
    }
}
