// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceAppManagement;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device App Management Request Builder.
 */
public class DeviceAppManagementRequestBuilder extends BaseRequestBuilder<DeviceAppManagement> {

    /**
     * The request builder for the DeviceAppManagement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceAppManagementRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the DeviceAppManagementRequest instance
     */
    @Nonnull
    public DeviceAppManagementRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the DeviceAppManagementRequest instance
     */
    @Nonnull
    public DeviceAppManagementRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.DeviceAppManagementRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the ManagedEBook collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedEBookCollectionRequestBuilder managedEBooks() {
        return new com.microsoft.graph.requests.ManagedEBookCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("managedEBooks"), getClient(), null);
    }

    /**
     * Gets a request builder for the ManagedEBook item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedEBookRequestBuilder managedEBooks(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ManagedEBookRequestBuilder(getRequestUrlWithAdditionalSegment("managedEBooks") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the MobileAppCategory collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.MobileAppCategoryCollectionRequestBuilder mobileAppCategories() {
        return new com.microsoft.graph.requests.MobileAppCategoryCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("mobileAppCategories"), getClient(), null);
    }

    /**
     * Gets a request builder for the MobileAppCategory item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.MobileAppCategoryRequestBuilder mobileAppCategories(@Nonnull final String id) {
        return new com.microsoft.graph.requests.MobileAppCategoryRequestBuilder(getRequestUrlWithAdditionalSegment("mobileAppCategories") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ManagedDeviceMobileAppConfiguration collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedDeviceMobileAppConfigurationCollectionRequestBuilder mobileAppConfigurations() {
        return new com.microsoft.graph.requests.ManagedDeviceMobileAppConfigurationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("mobileAppConfigurations"), getClient(), null);
    }

    /**
     * Gets a request builder for the ManagedDeviceMobileAppConfiguration item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedDeviceMobileAppConfigurationRequestBuilder mobileAppConfigurations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ManagedDeviceMobileAppConfigurationRequestBuilder(getRequestUrlWithAdditionalSegment("mobileAppConfigurations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the MobileApp collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.MobileAppCollectionRequestBuilder mobileApps() {
        return new com.microsoft.graph.requests.MobileAppCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("mobileApps"), getClient(), null);
    }

    /**
     * Gets a request builder for the MobileApp item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.MobileAppRequestBuilder mobileApps(@Nonnull final String id) {
        return new com.microsoft.graph.requests.MobileAppRequestBuilder(getRequestUrlWithAdditionalSegment("mobileApps") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the MobileLobApp collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.MobileLobAppCollectionRequestBuilder mobileAppsAsMobileLobApp() {
        return new com.microsoft.graph.requests.MobileLobAppCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("mobileApps") + "/microsoft.graph.mobileLobApp", getClient(), null);
    }

    /**
     * Gets a request builder for the MobileLobApp item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.MobileLobAppRequestBuilder mobileAppsAsMobileLobApp(@Nonnull final String id) {
        return new com.microsoft.graph.requests.MobileLobAppRequestBuilder(getRequestUrlWithAdditionalSegment("mobileApps") + "/" + id + "/microsoft.graph.mobileLobApp", getClient(), null);
    }
    /**
     *  Gets a request builder for the ManagedMobileLobApp collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedMobileLobAppCollectionRequestBuilder mobileAppsAsManagedMobileLobApp() {
        return new com.microsoft.graph.requests.ManagedMobileLobAppCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("mobileApps") + "/microsoft.graph.managedMobileLobApp", getClient(), null);
    }

    /**
     * Gets a request builder for the ManagedMobileLobApp item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedMobileLobAppRequestBuilder mobileAppsAsManagedMobileLobApp(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ManagedMobileLobAppRequestBuilder(getRequestUrlWithAdditionalSegment("mobileApps") + "/" + id + "/microsoft.graph.managedMobileLobApp", getClient(), null);
    }
    /**
     *  Gets a request builder for the VppToken collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.VppTokenCollectionRequestBuilder vppTokens() {
        return new com.microsoft.graph.requests.VppTokenCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("vppTokens"), getClient(), null);
    }

    /**
     * Gets a request builder for the VppToken item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.VppTokenRequestBuilder vppTokens(@Nonnull final String id) {
        return new com.microsoft.graph.requests.VppTokenRequestBuilder(getRequestUrlWithAdditionalSegment("vppTokens") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AndroidManagedAppProtection collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AndroidManagedAppProtectionCollectionRequestBuilder androidManagedAppProtections() {
        return new com.microsoft.graph.requests.AndroidManagedAppProtectionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("androidManagedAppProtections"), getClient(), null);
    }

    /**
     * Gets a request builder for the AndroidManagedAppProtection item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AndroidManagedAppProtectionRequestBuilder androidManagedAppProtections(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AndroidManagedAppProtectionRequestBuilder(getRequestUrlWithAdditionalSegment("androidManagedAppProtections") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the DefaultManagedAppProtection collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DefaultManagedAppProtectionCollectionRequestBuilder defaultManagedAppProtections() {
        return new com.microsoft.graph.requests.DefaultManagedAppProtectionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("defaultManagedAppProtections"), getClient(), null);
    }

    /**
     * Gets a request builder for the DefaultManagedAppProtection item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DefaultManagedAppProtectionRequestBuilder defaultManagedAppProtections(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DefaultManagedAppProtectionRequestBuilder(getRequestUrlWithAdditionalSegment("defaultManagedAppProtections") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the IosManagedAppProtection collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.IosManagedAppProtectionCollectionRequestBuilder iosManagedAppProtections() {
        return new com.microsoft.graph.requests.IosManagedAppProtectionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("iosManagedAppProtections"), getClient(), null);
    }

    /**
     * Gets a request builder for the IosManagedAppProtection item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.IosManagedAppProtectionRequestBuilder iosManagedAppProtections(@Nonnull final String id) {
        return new com.microsoft.graph.requests.IosManagedAppProtectionRequestBuilder(getRequestUrlWithAdditionalSegment("iosManagedAppProtections") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ManagedAppPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedAppPolicyCollectionRequestBuilder managedAppPolicies() {
        return new com.microsoft.graph.requests.ManagedAppPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("managedAppPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the ManagedAppPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedAppPolicyRequestBuilder managedAppPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ManagedAppPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("managedAppPolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ManagedAppRegistration collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedAppRegistrationCollectionRequestBuilder managedAppRegistrations() {
        return new com.microsoft.graph.requests.ManagedAppRegistrationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("managedAppRegistrations"), getClient(), null);
    }

    /**
     * Gets a request builder for the ManagedAppRegistration item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedAppRegistrationRequestBuilder managedAppRegistrations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ManagedAppRegistrationRequestBuilder(getRequestUrlWithAdditionalSegment("managedAppRegistrations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ManagedAppStatus collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedAppStatusCollectionRequestBuilder managedAppStatuses() {
        return new com.microsoft.graph.requests.ManagedAppStatusCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("managedAppStatuses"), getClient(), null);
    }

    /**
     * Gets a request builder for the ManagedAppStatus item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ManagedAppStatusRequestBuilder managedAppStatuses(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ManagedAppStatusRequestBuilder(getRequestUrlWithAdditionalSegment("managedAppStatuses") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the MdmWindowsInformationProtectionPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.MdmWindowsInformationProtectionPolicyCollectionRequestBuilder mdmWindowsInformationProtectionPolicies() {
        return new com.microsoft.graph.requests.MdmWindowsInformationProtectionPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("mdmWindowsInformationProtectionPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the MdmWindowsInformationProtectionPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.MdmWindowsInformationProtectionPolicyRequestBuilder mdmWindowsInformationProtectionPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.MdmWindowsInformationProtectionPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("mdmWindowsInformationProtectionPolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TargetedManagedAppConfiguration collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TargetedManagedAppConfigurationCollectionRequestBuilder targetedManagedAppConfigurations() {
        return new com.microsoft.graph.requests.TargetedManagedAppConfigurationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("targetedManagedAppConfigurations"), getClient(), null);
    }

    /**
     * Gets a request builder for the TargetedManagedAppConfiguration item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TargetedManagedAppConfigurationRequestBuilder targetedManagedAppConfigurations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TargetedManagedAppConfigurationRequestBuilder(getRequestUrlWithAdditionalSegment("targetedManagedAppConfigurations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WindowsInformationProtectionPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.WindowsInformationProtectionPolicyCollectionRequestBuilder windowsInformationProtectionPolicies() {
        return new com.microsoft.graph.requests.WindowsInformationProtectionPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("windowsInformationProtectionPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the WindowsInformationProtectionPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.WindowsInformationProtectionPolicyRequestBuilder windowsInformationProtectionPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.WindowsInformationProtectionPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("windowsInformationProtectionPolicies") + "/" + id, getClient(), null);
    }

    /**
     * Syncs Intune account with Microsoft Store For Business
     * @return the request builder
     */
    @Nonnull
    public DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequestBuilder syncMicrosoftStoreForBusinessApps() {
        return new DeviceAppManagementSyncMicrosoftStoreForBusinessAppsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.syncMicrosoftStoreForBusinessApps"), getClient(), null);
    }
}
