// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Remove Password Parameter Set.
 */
public class ServicePrincipalRemovePasswordParameterSet {
    /**
     * The key Id.
     * 
     */
    @SerializedName(value = "keyId", alternate = {"KeyId"})
    @Expose
	@Nullable
    public java.util.UUID keyId;


    /**
     * Instiaciates a new ServicePrincipalRemovePasswordParameterSet
     */
    public ServicePrincipalRemovePasswordParameterSet() {}
    /**
     * Instiaciates a new ServicePrincipalRemovePasswordParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ServicePrincipalRemovePasswordParameterSet(@Nonnull final ServicePrincipalRemovePasswordParameterSetBuilder builder) {
        this.keyId = builder.keyId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ServicePrincipalRemovePasswordParameterSetBuilder newBuilder() {
        return new ServicePrincipalRemovePasswordParameterSetBuilder();
    }
    /**
     * Fluent builder for the ServicePrincipalRemovePasswordParameterSet
     */
    public static final class ServicePrincipalRemovePasswordParameterSetBuilder {
        /**
         * The keyId parameter value
         */
        @Nullable
        protected java.util.UUID keyId;
        /**
         * Sets the KeyId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ServicePrincipalRemovePasswordParameterSetBuilder withKeyId(@Nullable final java.util.UUID val) {
            this.keyId = val;
            return this;
        }
        /**
         * Instanciates a new ServicePrincipalRemovePasswordParameterSetBuilder
         */
        @Nullable
        protected ServicePrincipalRemovePasswordParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ServicePrincipalRemovePasswordParameterSet build() {
            return new ServicePrincipalRemovePasswordParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.keyId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("keyId", keyId));
        }
        return result;
    }
}
