/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.Domain;
import com.microsoft.graph.models.DomainForceDeleteParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.DomainDnsRecordCollectionRequestBuilder;
import com.microsoft.graph.requests.DomainDnsRecordRequestBuilder;
import com.microsoft.graph.requests.DomainForceDeleteRequestBuilder;
import com.microsoft.graph.requests.DomainRequest;
import com.microsoft.graph.requests.DomainVerifyRequestBuilder;
import com.microsoft.graph.requests.InternalDomainFederationCollectionRequestBuilder;
import com.microsoft.graph.requests.InternalDomainFederationRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DomainRequestBuilder
extends BaseRequestBuilder<Domain> {
    public DomainRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public DomainRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public DomainRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new DomainRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public DirectoryObjectCollectionWithReferencesRequestBuilder domainNameReferences() {
        return new DirectoryObjectCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("domainNameReferences"), this.getClient(), null);
    }

    @Nonnull
    public DirectoryObjectWithReferenceRequestBuilder domainNameReferences(@Nonnull String id) {
        return new DirectoryObjectWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("domainNameReferences") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public InternalDomainFederationCollectionRequestBuilder federationConfiguration() {
        return new InternalDomainFederationCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("federationConfiguration"), this.getClient(), null);
    }

    @Nonnull
    public InternalDomainFederationRequestBuilder federationConfiguration(@Nonnull String id) {
        return new InternalDomainFederationRequestBuilder(this.getRequestUrlWithAdditionalSegment("federationConfiguration") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DomainDnsRecordCollectionRequestBuilder serviceConfigurationRecords() {
        return new DomainDnsRecordCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("serviceConfigurationRecords"), this.getClient(), null);
    }

    @Nonnull
    public DomainDnsRecordRequestBuilder serviceConfigurationRecords(@Nonnull String id) {
        return new DomainDnsRecordRequestBuilder(this.getRequestUrlWithAdditionalSegment("serviceConfigurationRecords") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DomainDnsRecordCollectionRequestBuilder verificationDnsRecords() {
        return new DomainDnsRecordCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("verificationDnsRecords"), this.getClient(), null);
    }

    @Nonnull
    public DomainDnsRecordRequestBuilder verificationDnsRecords(@Nonnull String id) {
        return new DomainDnsRecordRequestBuilder(this.getRequestUrlWithAdditionalSegment("verificationDnsRecords") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DomainForceDeleteRequestBuilder forceDelete(@Nonnull DomainForceDeleteParameterSet parameters) {
        return new DomainForceDeleteRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.forceDelete"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DomainVerifyRequestBuilder verify() {
        return new DomainVerifyRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.verify"), this.getClient(), null);
    }
}

