// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TemporaryAccessPassAuthenticationMethod;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Temporary Access Pass Authentication Method Request.
 */
public class TemporaryAccessPassAuthenticationMethodRequest extends BaseRequest<TemporaryAccessPassAuthenticationMethod> {
	
    /**
     * The request for the TemporaryAccessPassAuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TemporaryAccessPassAuthenticationMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TemporaryAccessPassAuthenticationMethod.class);
    }

    /**
     * Gets the TemporaryAccessPassAuthenticationMethod from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethod> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TemporaryAccessPassAuthenticationMethod from the service
     *
     * @return the TemporaryAccessPassAuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethod> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethod delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TemporaryAccessPassAuthenticationMethod with a source
     *
     * @param sourceTemporaryAccessPassAuthenticationMethod the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethod> patchAsync(@Nonnull final TemporaryAccessPassAuthenticationMethod sourceTemporaryAccessPassAuthenticationMethod) {
        return sendAsync(HttpMethod.PATCH, sourceTemporaryAccessPassAuthenticationMethod);
    }

    /**
     * Patches this TemporaryAccessPassAuthenticationMethod with a source
     *
     * @param sourceTemporaryAccessPassAuthenticationMethod the source object with updates
     * @return the updated TemporaryAccessPassAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethod patch(@Nonnull final TemporaryAccessPassAuthenticationMethod sourceTemporaryAccessPassAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourceTemporaryAccessPassAuthenticationMethod);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethod with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethod the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethod> postAsync(@Nonnull final TemporaryAccessPassAuthenticationMethod newTemporaryAccessPassAuthenticationMethod) {
        return sendAsync(HttpMethod.POST, newTemporaryAccessPassAuthenticationMethod);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethod with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethod the new object to create
     * @return the created TemporaryAccessPassAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethod post(@Nonnull final TemporaryAccessPassAuthenticationMethod newTemporaryAccessPassAuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newTemporaryAccessPassAuthenticationMethod);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethod with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethod the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethod> putAsync(@Nonnull final TemporaryAccessPassAuthenticationMethod newTemporaryAccessPassAuthenticationMethod) {
        return sendAsync(HttpMethod.PUT, newTemporaryAccessPassAuthenticationMethod);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethod with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethod the object to create/update
     * @return the created TemporaryAccessPassAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethod put(@Nonnull final TemporaryAccessPassAuthenticationMethod newTemporaryAccessPassAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newTemporaryAccessPassAuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TemporaryAccessPassAuthenticationMethodRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TemporaryAccessPassAuthenticationMethodRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

