// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Channel;
import com.microsoft.graph.models.ProvisionChannelEmailResult;
import com.microsoft.graph.models.ChatMessage;
import com.microsoft.graph.requests.DriveItemRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberRequestBuilder;
import com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.ChatMessageRequestBuilder;
import com.microsoft.graph.requests.SharedWithChannelTeamInfoCollectionRequestBuilder;
import com.microsoft.graph.requests.SharedWithChannelTeamInfoRequestBuilder;
import com.microsoft.graph.requests.TeamsTabCollectionRequestBuilder;
import com.microsoft.graph.requests.TeamsTabRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.ChannelDoesUserHaveAccessParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Channel Request Builder.
 */
public class ChannelRequestBuilder extends BaseRequestBuilder<Channel> {

    /**
     * The request builder for the Channel
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChannelRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ChannelRequest instance
     */
    @Nonnull
    public ChannelRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ChannelRequest instance
     */
    @Nonnull
    public ChannelRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.ChannelRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for DriveItem
     *
     * @return the DriveItemRequestBuilder instance
     */
    @Nonnull
    public DriveItemRequestBuilder filesFolder() {
        return new DriveItemRequestBuilder(getRequestUrlWithAdditionalSegment("filesFolder"), getClient(), null);
    }
    /**
     *  Gets a request builder for the ConversationMember collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public ConversationMemberCollectionRequestBuilder members() {
        return new ConversationMemberCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("members"), getClient(), null);
    }

    /**
     * Gets a request builder for the ConversationMember item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public ConversationMemberRequestBuilder members(@Nonnull final String id) {
        return new ConversationMemberRequestBuilder(getRequestUrlWithAdditionalSegment("members") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ChatMessage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public ChatMessageCollectionRequestBuilder messages() {
        return new ChatMessageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("messages"), getClient(), null);
    }

    /**
     * Gets a request builder for the ChatMessage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public ChatMessageRequestBuilder messages(@Nonnull final String id) {
        return new ChatMessageRequestBuilder(getRequestUrlWithAdditionalSegment("messages") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the SharedWithChannelTeamInfo collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public SharedWithChannelTeamInfoCollectionRequestBuilder sharedWithTeams() {
        return new SharedWithChannelTeamInfoCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sharedWithTeams"), getClient(), null);
    }

    /**
     * Gets a request builder for the SharedWithChannelTeamInfo item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public SharedWithChannelTeamInfoRequestBuilder sharedWithTeams(@Nonnull final String id) {
        return new SharedWithChannelTeamInfoRequestBuilder(getRequestUrlWithAdditionalSegment("sharedWithTeams") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TeamsTab collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public TeamsTabCollectionRequestBuilder tabs() {
        return new TeamsTabCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tabs"), getClient(), null);
    }

    /**
     * Gets a request builder for the TeamsTab item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public TeamsTabRequestBuilder tabs(@Nonnull final String id) {
        return new TeamsTabRequestBuilder(getRequestUrlWithAdditionalSegment("tabs") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ChannelCompleteMigrationRequestBuilder completeMigration() {
        return new ChannelCompleteMigrationRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.completeMigration"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ChannelProvisionEmailRequestBuilder provisionEmail() {
        return new ChannelProvisionEmailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.provisionEmail"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ChannelRemoveEmailRequestBuilder removeEmail() {
        return new ChannelRemoveEmailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.removeEmail"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ChannelDoesUserHaveAccessRequestBuilder doesUserHaveAccess(@Nonnull final ChannelDoesUserHaveAccessParameterSet parameters) {
        return new ChannelDoesUserHaveAccessRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.doesUserHaveAccess"), getClient(), null, parameters);
    }
}
