/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.MailFolderCollectionPage;
import com.microsoft.graph.requests.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderCollectionResponse;
import com.microsoft.graph.requests.MailFolderRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MailFolderCollectionRequest
extends BaseEntityCollectionRequest<MailFolder, MailFolderCollectionResponse, MailFolderCollectionPage> {
    public MailFolderCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MailFolderCollectionResponse.class, MailFolderCollectionPage.class, MailFolderCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<MailFolder> postAsync(@Nonnull MailFolder newMailFolder) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newMailFolder);
    }

    @Nonnull
    public MailFolder post(@Nonnull MailFolder newMailFolder) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMailFolder);
    }

    @Nonnull
    public MailFolderCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public MailFolderCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

