// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.SectionGroup;
import com.microsoft.graph.models.OnenoteSection;
import com.microsoft.graph.models.OnenoteEntityHierarchyModel;
import com.microsoft.graph.requests.SectionGroupCollectionPage;
import com.microsoft.graph.requests.OnenoteSectionCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Section Group.
 */
public class SectionGroup extends OnenoteEntityHierarchyModel implements IJsonBackedObject {


    /**
     * The Section Groups Url.
     * The URL for the sectionGroups navigation property, which returns all the section groups in the section group. Read-only.
     */
    @SerializedName(value = "sectionGroupsUrl", alternate = {"SectionGroupsUrl"})
    @Expose
	@Nullable
    public String sectionGroupsUrl;

    /**
     * The Sections Url.
     * The URL for the sections navigation property, which returns all the sections in the section group. Read-only.
     */
    @SerializedName(value = "sectionsUrl", alternate = {"SectionsUrl"})
    @Expose
	@Nullable
    public String sectionsUrl;

    /**
     * The Parent Notebook.
     * The notebook that contains the section group. Read-only.
     */
    @SerializedName(value = "parentNotebook", alternate = {"ParentNotebook"})
    @Expose
	@Nullable
    public Notebook parentNotebook;

    /**
     * The Parent Section Group.
     * The section group that contains the section group. Read-only.
     */
    @SerializedName(value = "parentSectionGroup", alternate = {"ParentSectionGroup"})
    @Expose
	@Nullable
    public SectionGroup parentSectionGroup;

    /**
     * The Section Groups.
     * The section groups in the section. Read-only. Nullable.
     */
    @SerializedName(value = "sectionGroups", alternate = {"SectionGroups"})
    @Expose
	@Nullable
    public SectionGroupCollectionPage sectionGroups;

    /**
     * The Sections.
     * The sections in the section group. Read-only. Nullable.
     */
    @SerializedName(value = "sections", alternate = {"Sections"})
    @Expose
	@Nullable
    public OnenoteSectionCollectionPage sections;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("sectionGroups")) {
            sectionGroups = serializer.deserializeObject(json.get("sectionGroups"), SectionGroupCollectionPage.class);
        }

        if (json.has("sections")) {
            sections = serializer.deserializeObject(json.get("sections"), OnenoteSectionCollectionPage.class);
        }
    }
}
