// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ManagedAppDataEncryptionType;
import com.microsoft.graph.models.ManagedMobileApp;
import com.microsoft.graph.models.ManagedAppPolicyDeploymentSummary;
import com.microsoft.graph.models.TargetedManagedAppProtection;
import com.microsoft.graph.requests.ManagedMobileAppCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Managed App Protection.
 */
public class IosManagedAppProtection extends TargetedManagedAppProtection implements IJsonBackedObject {


    /**
     * The App Data Encryption Type.
     * Type of encryption which should be used for data in a managed app. Possible values are: useDeviceSettings, afterDeviceRestart, whenDeviceLockedExceptOpenFiles, whenDeviceLocked.
     */
    @SerializedName(value = "appDataEncryptionType", alternate = {"AppDataEncryptionType"})
    @Expose
	@Nullable
    public ManagedAppDataEncryptionType appDataEncryptionType;

    /**
     * The Custom Browser Protocol.
     * A custom browser protocol to open weblink on iOS.
     */
    @SerializedName(value = "customBrowserProtocol", alternate = {"CustomBrowserProtocol"})
    @Expose
	@Nullable
    public String customBrowserProtocol;

    /**
     * The Deployed App Count.
     * Count of apps to which the current policy is deployed.
     */
    @SerializedName(value = "deployedAppCount", alternate = {"DeployedAppCount"})
    @Expose
	@Nullable
    public Integer deployedAppCount;

    /**
     * The Face Id Blocked.
     * Indicates whether use of the FaceID is allowed in place of a pin if PinRequired is set to True.
     */
    @SerializedName(value = "faceIdBlocked", alternate = {"FaceIdBlocked"})
    @Expose
	@Nullable
    public Boolean faceIdBlocked;

    /**
     * The Minimum Required Sdk Version.
     * Versions less than the specified version will block the managed app from accessing company data.
     */
    @SerializedName(value = "minimumRequiredSdkVersion", alternate = {"MinimumRequiredSdkVersion"})
    @Expose
	@Nullable
    public String minimumRequiredSdkVersion;

    /**
     * The Apps.
     * List of apps to which the policy is deployed.
     */
    @SerializedName(value = "apps", alternate = {"Apps"})
    @Expose
	@Nullable
    public ManagedMobileAppCollectionPage apps;

    /**
     * The Deployment Summary.
     * Navigation property to deployment summary of the configuration.
     */
    @SerializedName(value = "deploymentSummary", alternate = {"DeploymentSummary"})
    @Expose
	@Nullable
    public ManagedAppPolicyDeploymentSummary deploymentSummary;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("apps")) {
            apps = serializer.deserializeObject(json.get("apps"), ManagedMobileAppCollectionPage.class);
        }
    }
}
