// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AttestationLevel;
import com.microsoft.graph.models.AuthenticationMethod;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Fido2Authentication Method.
 */
public class Fido2AuthenticationMethod extends AuthenticationMethod implements IJsonBackedObject {


    /**
     * The Aa Guid.
     * Authenticator Attestation GUID, an identifier that indicates the type (e.g. make and model) of the authenticator.
     */
    @SerializedName(value = "aaGuid", alternate = {"AaGuid"})
    @Expose
	@Nullable
    public String aaGuid;

    /**
     * The Attestation Certificates.
     * The attestation certificate(s) attached to this security key.
     */
    @SerializedName(value = "attestationCertificates", alternate = {"AttestationCertificates"})
    @Expose
	@Nullable
    public java.util.List<String> attestationCertificates;

    /**
     * The Attestation Level.
     * The attestation level of this FIDO2 security key. Possible values are: attested, notAttested, unknownFutureValue.
     */
    @SerializedName(value = "attestationLevel", alternate = {"AttestationLevel"})
    @Expose
	@Nullable
    public AttestationLevel attestationLevel;

    /**
     * The Created Date Time.
     * The timestamp when this key was registered to the user.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Display Name.
     * The display name of the key as given by the user.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Model.
     * The manufacturer-assigned model of the FIDO2 security key.
     */
    @SerializedName(value = "model", alternate = {"Model"})
    @Expose
	@Nullable
    public String model;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
