// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.termstore.models.Set;
import com.microsoft.graph.termstore.requests.TermCollectionRequestBuilder;
import com.microsoft.graph.termstore.requests.TermRequestBuilder;
import com.microsoft.graph.termstore.requests.GroupRequestBuilder;
import com.microsoft.graph.termstore.requests.RelationCollectionRequestBuilder;
import com.microsoft.graph.termstore.requests.RelationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Set Request Builder.
 */
public class SetRequestBuilder extends BaseRequestBuilder<Set> {

    /**
     * The request builder for the Set
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SetRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the SetRequest instance
     */
    @Nonnull
    public SetRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the SetRequest instance
     */
    @Nonnull
    public SetRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.termstore.requests.SetRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the Term collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public TermCollectionRequestBuilder children() {
        return new TermCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("children"), getClient(), null);
    }

    /**
     * Gets a request builder for the Term item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public TermRequestBuilder children(@Nonnull final String id) {
        return new TermRequestBuilder(getRequestUrlWithAdditionalSegment("children") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for Group
     *
     * @return the GroupRequestBuilder instance
     */
    @Nonnull
    public GroupRequestBuilder parentGroup() {
        return new GroupRequestBuilder(getRequestUrlWithAdditionalSegment("parentGroup"), getClient(), null);
    }
    /**
     *  Gets a request builder for the Relation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public RelationCollectionRequestBuilder relations() {
        return new RelationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("relations"), getClient(), null);
    }

    /**
     * Gets a request builder for the Relation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public RelationRequestBuilder relations(@Nonnull final String id) {
        return new RelationRequestBuilder(getRequestUrlWithAdditionalSegment("relations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Term collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public TermCollectionRequestBuilder terms() {
        return new TermCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("terms"), getClient(), null);
    }

    /**
     * Gets a request builder for the Term item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public TermRequestBuilder terms(@Nonnull final String id) {
        return new TermRequestBuilder(getRequestUrlWithAdditionalSegment("terms") + "/" + id, getClient(), null);
    }
}
